/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class DefaultServerHttpRequestBuilder
implements ServerHttpRequest.Builder {
    private URI uri;
    private HttpHeaders httpHeaders;
    private String httpMethodValue;
    private final MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private final InetSocketAddress remoteAddress;
    @Nullable
    private String uriPath;
    @Nullable
    private String contextPath;
    private Flux<DataBuffer> body;
    private final ServerHttpRequest originalRequest;

    public DefaultServerHttpRequestBuilder(ServerHttpRequest original) {
        Assert.notNull((Object)original, "ServerHttpRequest is required");
        this.uri = original.getURI();
        this.httpMethodValue = original.getMethodValue();
        this.remoteAddress = original.getRemoteAddress();
        this.body = original.getBody();
        this.httpHeaders = new HttpHeaders();
        DefaultServerHttpRequestBuilder.copyMultiValueMap(original.getHeaders(), this.httpHeaders);
        this.cookies = new LinkedMultiValueMap<String, HttpCookie>(original.getCookies().size());
        DefaultServerHttpRequestBuilder.copyMultiValueMap(original.getCookies(), this.cookies);
        this.originalRequest = original;
    }

    private static <K, V> void copyMultiValueMap(MultiValueMap<K, V> source, MultiValueMap<K, V> destination) {
        for (Map.Entry entry : source.entrySet()) {
            Object key = entry.getKey();
            LinkedList values = new LinkedList((Collection)entry.getValue());
            destination.put(key, values);
        }
    }

    @Override
    public ServerHttpRequest.Builder method(HttpMethod httpMethod) {
        this.httpMethodValue = httpMethod.name();
        return this;
    }

    @Override
    public ServerHttpRequest.Builder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder path(String path) {
        this.uriPath = path;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder header(String key, String value) {
        this.httpHeaders.add(key, value);
        return this;
    }

    @Override
    public ServerHttpRequest.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        Assert.notNull(headersConsumer, "'headersConsumer' must not be null");
        headersConsumer.accept(this.httpHeaders);
        return this;
    }

    @Override
    public ServerHttpRequest build() {
        URI uriToUse = this.getUriToUse();
        return new DefaultServerHttpRequest(uriToUse, this.contextPath, this.httpHeaders, this.httpMethodValue, this.cookies, this.remoteAddress, this.body, this.originalRequest);
    }

    private URI getUriToUse() {
        if (this.uriPath == null) {
            return this.uri;
        }
        try {
            return new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uriPath, this.uri.getQuery(), this.uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Invalid URI path: \"" + this.uriPath + "\"");
        }
    }

    private static class DefaultServerHttpRequest
    extends AbstractServerHttpRequest {
        private final String methodValue;
        private final MultiValueMap<String, HttpCookie> cookies;
        @Nullable
        private final InetSocketAddress remoteAddress;
        private final Flux<DataBuffer> body;
        private final ServerHttpRequest originalRequest;

        public DefaultServerHttpRequest(URI uri, @Nullable String contextPath, HttpHeaders headers, String methodValue, MultiValueMap<String, HttpCookie> cookies, @Nullable InetSocketAddress remoteAddress, Flux<DataBuffer> body, ServerHttpRequest originalRequest) {
            super(uri, contextPath, headers);
            this.methodValue = methodValue;
            this.cookies = cookies;
            this.remoteAddress = remoteAddress;
            this.body = body;
            this.originalRequest = originalRequest;
        }

        @Override
        public String getMethodValue() {
            return this.methodValue;
        }

        @Override
        protected MultiValueMap<String, HttpCookie> initCookies() {
            return this.cookies;
        }

        @Override
        @Nullable
        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public Flux<DataBuffer> getBody() {
            return this.body;
        }

        @Override
        public <T> T getNativeRequest() {
            return (T)this.originalRequest;
        }
    }
}

