/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModificationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ITagsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonObject(value="as.dto.material.Material")
public class Material
implements Serializable,
ICodeHolder,
IEntityTypeHolder,
IMaterialPropertiesHolder,
IModificationDateHolder,
IPermIdHolder,
IPropertiesHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ITagsHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private MaterialFetchOptions fetchOptions;
    @JsonProperty
    private MaterialPermId permId;
    @JsonProperty
    private String code;
    @JsonProperty
    private MaterialType type;
    @JsonProperty
    private List<HistoryEntry> history;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Date modificationDate;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private Map<String, Material> materialProperties;
    @JsonProperty
    private Set<Tag> tags;

    @JsonIgnore
    public MaterialFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(MaterialFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public MaterialPermId getPermId() {
        return this.permId;
    }

    public void setPermId(MaterialPermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @JsonIgnore
    public MaterialType getType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasType()) {
            return this.type;
        }
        throw new NotFetchedException("Material type has not been fetched.");
    }

    public void setType(MaterialType type) {
        this.type = type;
    }

    @JsonIgnore
    public List<HistoryEntry> getHistory() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasHistory()) {
            return this.history;
        }
        throw new NotFetchedException("History have not been fetched.");
    }

    public void setHistory(List<HistoryEntry> history) {
        this.history = history;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProperties()) {
            return this.properties;
        }
        throw new NotFetchedException("Properties have not been fetched.");
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Material> getMaterialProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterialProperties()) {
            return this.materialProperties;
        }
        throw new NotFetchedException("Material Properties have not been fetched.");
    }

    @Override
    public void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    @Override
    @JsonIgnore
    public Set<Tag> getTags() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasTags()) {
            return this.tags;
        }
        throw new NotFetchedException("Tags have not been fetched.");
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.getProperties() != null ? this.getProperties().get(propertyName) : null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, propertyValue);
    }

    @Override
    public Material getMaterialProperty(String propertyName) {
        return this.getMaterialProperties() != null ? this.getMaterialProperties().get(propertyName) : null;
    }

    @Override
    public void setMaterialProperty(String propertyName, Material propertyValue) {
        if (this.materialProperties == null) {
            this.materialProperties = new HashMap<String, Material>();
        }
        this.materialProperties.put(propertyName, propertyValue);
    }

    public String toString() {
        return "Material " + this.code;
    }
}

