/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.json.jackson;

import ch.ethz.sis.microservices.download.server.json.JSONObjectMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;

public class JacksonObjectMapper
implements JSONObjectMapper {
    private static final JacksonObjectMapper jacksonObjectMapper = new JacksonObjectMapper();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public static JSONObjectMapper getInstance() {
        return jacksonObjectMapper;
    }

    private JacksonObjectMapper() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.enableDefaultTyping();
    }

    @Override
    public <T> T readValue(InputStream src, Class<T> valueType) throws Exception {
        return (T)this.objectMapper.readValue(src, valueType);
    }

    @Override
    public <T> T readValue(InputStream src, TypeReference<T> typeRef) throws Exception {
        return (T)this.objectMapper.readValue(src, typeRef);
    }

    @Override
    public byte[] writeValue(Object value) throws Exception {
        return this.objectMapper.writeValueAsBytes(value);
    }
}

