/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class OSUtilities {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isMacOS() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public static String getCompatibleComputerPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            osName = "Windows";
        }
        return System.getProperty("os.arch") + "-" + osName;
    }

    public static String getCPUArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getComputerPlatform() {
        return System.getProperty("os.arch") + "-" + System.getProperty("os.name");
    }

    public static String getUsername() {
        return System.getProperty("user.name");
    }

    public static boolean isRoot() {
        if (OSUtilities.isUnix()) {
            return "root".equals(OSUtilities.getUsername());
        }
        return "Administrator".equals(OSUtilities.getUsername());
    }

    public static Set<String> getOSPath() {
        String[] pathEntries = System.getenv("PATH").split(Pattern.quote(System.getProperty("path.separator")));
        return new LinkedHashSet<String>(Arrays.asList(pathEntries));
    }

    public static Set<String> getSafeOSPath(boolean root) {
        Set<String> pathEntries = OSUtilities.getOSPath();
        if (OSUtilities.isUnix()) {
            if (OSUtilities.isMacOS()) {
                pathEntries.add("/opt/local/bin");
                pathEntries.add("/sw/bin");
                if (root) {
                    pathEntries.add("/opt/local/sbin");
                    pathEntries.add("/sw/sbin");
                }
            }
            pathEntries.add("/usr/local/bin");
            pathEntries.add("/usr/bin");
            pathEntries.add("/bin");
            if (root) {
                pathEntries.add("/usr/local/sbin");
                pathEntries.add("/usr/sbin");
                pathEntries.add("/sbin");
            }
        }
        return pathEntries;
    }

    public static Set<String> getSafeOSPath() {
        return OSUtilities.getSafeOSPath(false);
    }

    public static File findExecutable(String executableName) {
        return OSUtilities.findExecutable(executableName, OSUtilities.getSafeOSPath());
    }

    public static File findExecutable(String executableName, Set<String> pathSet) {
        String executableNameWithExtension = OSUtilities.addWindowsExecutableExtensionIfNecessary(executableName);
        for (String dir : pathSet) {
            File fileToCheck = new File(dir, executableNameWithExtension);
            if (!fileToCheck.exists()) continue;
            return fileToCheck;
        }
        return null;
    }

    public static boolean executableExists(String executableName) {
        return new File(OSUtilities.addWindowsExecutableExtensionIfNecessary(executableName)).exists();
    }

    public static boolean executableExists(File executable) {
        return new File(OSUtilities.addWindowsExecutableExtensionIfNecessary(executable.getPath())).exists();
    }

    private static String addWindowsExecutableExtensionIfNecessary(String executableName) {
        if (OSUtilities.isWindows() && executableName.indexOf(46) < 0) {
            return executableName + ".exe";
        }
        return executableName;
    }
}

