/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.IRetryAction;
import ch.ethz.sis.filetransfer.IRetryProvider;
import ch.ethz.sis.filetransfer.LogLevel;

public class DefaultRetryProvider
implements IRetryProvider {
    private ILogger logger;
    private int maximumNumberOfRetries;
    private int waitingTimeBetweenRetries;
    private int waitingTimeBetweenRetriesIncreasingFactor;

    public DefaultRetryProvider(ILogger logger) {
        this(logger, 5, 1000, 2);
    }

    public DefaultRetryProvider(ILogger logger, int maximumNumberOfRetries, int waitingTimeBetweenRetries, int waitingTimeBetweenRetriesIncreasingFactor) {
        if (maximumNumberOfRetries < 0) {
            throw new IllegalArgumentException("MaximumNumberOfRetries must be >= 0");
        }
        if (waitingTimeBetweenRetries <= 0) {
            throw new IllegalArgumentException("WaitingTimeBetweenRetries must be > 0");
        }
        if (waitingTimeBetweenRetriesIncreasingFactor <= 0) {
            throw new IllegalArgumentException("WaitingTimeBetweenRetriesIncreasingFactor must be > 0");
        }
        this.logger = logger;
        this.maximumNumberOfRetries = maximumNumberOfRetries;
        this.waitingTimeBetweenRetries = waitingTimeBetweenRetries;
        this.waitingTimeBetweenRetriesIncreasingFactor = waitingTimeBetweenRetriesIncreasingFactor;
    }

    @Override
    public <T> T executeWithRetry(IRetryAction<T> action) throws DownloadException {
        return new Retry().callWithRetry(action);
    }

    private class Retry {
        private int retryCounter;
        private int waitingTime;

        public Retry() {
            this.waitingTime = DefaultRetryProvider.this.waitingTimeBetweenRetries;
        }

        public <T> T callWithRetry(IRetryAction<T> action) throws DownloadException {
            while (true) {
                try {
                    T result = action.execute();
                    this.retryCounter = 0;
                    return result;
                }
                catch (Exception e) {
                    if (this.isRetriable(e)) {
                        if (this.retryCounter < DefaultRetryProvider.this.maximumNumberOfRetries) {
                            if (DefaultRetryProvider.this.logger.isEnabled(LogLevel.WARN)) {
                                DefaultRetryProvider.this.logger.log(this.getClass(), LogLevel.WARN, "Call failed - will retry in " + this.waitingTime / 1000 + " second(s)", e);
                            }
                            this.waitForRetry();
                            if (!DefaultRetryProvider.this.logger.isEnabled(LogLevel.WARN)) continue;
                            DefaultRetryProvider.this.logger.log(this.getClass(), LogLevel.WARN, "Retrying (" + this.retryCounter + "/" + DefaultRetryProvider.this.maximumNumberOfRetries + ")");
                            continue;
                        }
                        if (DefaultRetryProvider.this.logger.isEnabled(LogLevel.WARN)) {
                            DefaultRetryProvider.this.logger.log(this.getClass(), LogLevel.WARN, "Call failed - will NOT retry (maximum number of " + DefaultRetryProvider.this.maximumNumberOfRetries + " reties has been already reached)", e);
                        }
                        throw e;
                    }
                    throw e;
                }
                break;
            }
        }

        private void waitForRetry() {
            try {
                Thread.sleep(this.waitingTime);
                this.waitingTime *= DefaultRetryProvider.this.waitingTimeBetweenRetriesIncreasingFactor;
                ++this.retryCounter;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        protected boolean isRetriable(Exception e) {
            if (e instanceof DownloadException) {
                DownloadException de = (DownloadException)e;
                return de.isRetriable() != null && de.isRetriable() != false;
            }
            return false;
        }
    }
}

