/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.Relationship;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IAttachmentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDataSetsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IExperimentHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IIdentifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModificationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IParentChildrenHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISpaceHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ITagsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonObject(value="as.dto.sample.Sample")
public class Sample
implements Serializable,
IAttachmentsHolder,
ICodeHolder,
IDataSetsHolder,
IEntityTypeHolder,
IExperimentHolder,
IIdentifierHolder,
IMaterialPropertiesHolder,
IModificationDateHolder,
IModifierHolder,
IParentChildrenHolder<Sample>,
IPermIdHolder,
IProjectHolder,
IPropertiesHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISpaceHolder,
ITagsHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private SampleFetchOptions fetchOptions;
    @JsonProperty
    private SamplePermId permId;
    @JsonProperty
    private SampleIdentifier identifier;
    @JsonProperty
    private String code;
    @JsonProperty
    private boolean frozen;
    @JsonProperty
    private boolean frozenForComponents;
    @JsonProperty
    private boolean frozenForChildren;
    @JsonProperty
    private boolean frozenForParents;
    @JsonProperty
    private boolean frozenForDataSets;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Date modificationDate;
    @JsonProperty
    private SampleType type;
    @JsonProperty
    private Project project;
    @JsonProperty
    private Space space;
    @JsonProperty
    private Experiment experiment;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private Map<String, Material> materialProperties;
    @JsonProperty
    private Map<String, Sample> sampleProperties;
    @JsonProperty
    private List<Sample> parents;
    @JsonProperty
    private Map<SamplePermId, Relationship> parentsRelationships;
    @JsonProperty
    private List<Sample> children;
    @JsonProperty
    private Map<SamplePermId, Relationship> childrenRelationships;
    @JsonProperty
    private Sample container;
    @JsonProperty
    private List<Sample> components;
    @JsonProperty
    private List<DataSet> dataSets;
    @JsonProperty
    private List<HistoryEntry> history;
    @JsonProperty
    private Set<Tag> tags;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Person modifier;
    @JsonProperty
    private List<Attachment> attachments;

    @JsonIgnore
    public SampleFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(SampleFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public SamplePermId getPermId() {
        return this.permId;
    }

    public void setPermId(SamplePermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public SampleIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(SampleIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isFrozenForComponents() {
        return this.frozenForComponents;
    }

    public void setFrozenForComponents(boolean frozenForComponents) {
        this.frozenForComponents = frozenForComponents;
    }

    public boolean isFrozenForChildren() {
        return this.frozenForChildren;
    }

    public void setFrozenForChildren(boolean frozenForChildren) {
        this.frozenForChildren = frozenForChildren;
    }

    public boolean isFrozenForParents() {
        return this.frozenForParents;
    }

    public void setFrozenForParents(boolean frozenForParents) {
        this.frozenForParents = frozenForParents;
    }

    public boolean isFrozenForDataSets() {
        return this.frozenForDataSets;
    }

    public void setFrozenForDataSets(boolean frozenForDataSets) {
        this.frozenForDataSets = frozenForDataSets;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @JsonIgnore
    public SampleType getType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasType()) {
            return this.type;
        }
        throw new NotFetchedException("Sample type has not been fetched.");
    }

    public void setType(SampleType type) {
        this.type = type;
    }

    @Override
    @JsonIgnore
    public Project getProject() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProject()) {
            return this.project;
        }
        throw new NotFetchedException("Project has not been fetched.");
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    @JsonIgnore
    public Space getSpace() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSpace()) {
            return this.space;
        }
        throw new NotFetchedException("Space has not been fetched.");
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    @Override
    @JsonIgnore
    public Experiment getExperiment() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasExperiment()) {
            return this.experiment;
        }
        throw new NotFetchedException("Experiment has not been fetched.");
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProperties()) {
            return this.properties;
        }
        throw new NotFetchedException("Properties have not been fetched.");
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Material> getMaterialProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterialProperties()) {
            return this.materialProperties;
        }
        throw new NotFetchedException("Material Properties have not been fetched.");
    }

    @Override
    public void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    @JsonIgnore
    public Map<String, Sample> getSampleProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSampleProperties()) {
            return this.sampleProperties;
        }
        throw new NotFetchedException("Sample Properties have not been fetched.");
    }

    public void setSampleProperties(Map<String, Sample> sampleProperties) {
        this.sampleProperties = sampleProperties;
    }

    @Override
    @JsonIgnore
    public List<Sample> getParents() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasParents()) {
            return this.parents;
        }
        throw new NotFetchedException("Parents have not been fetched.");
    }

    public void setParents(List<Sample> parents) {
        this.parents = parents;
    }

    @JsonIgnore
    public Map<SamplePermId, Relationship> getParentsRelationships() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasParents()) {
            return this.parentsRelationships;
        }
        throw new NotFetchedException("Parents have not been fetched.");
    }

    @JsonIgnore
    public Relationship getParentRelationship(ISampleId parentId) {
        Map<SamplePermId, Relationship> relationships = this.getParentsRelationships();
        return relationships == null ? new Relationship() : relationships.get(parentId);
    }

    public void setParentsRelationships(Map<SamplePermId, Relationship> parentsRelationships) {
        this.parentsRelationships = parentsRelationships;
    }

    @Override
    @JsonIgnore
    public List<Sample> getChildren() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasChildren()) {
            return this.children;
        }
        throw new NotFetchedException("Children have not been fetched.");
    }

    public void setChildren(List<Sample> children) {
        this.children = children;
    }

    @JsonIgnore
    public Map<SamplePermId, Relationship> getChildrenRelationships() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasChildren()) {
            return this.childrenRelationships;
        }
        throw new NotFetchedException("Children have not been fetched.");
    }

    @JsonIgnore
    public Relationship getChildRelationship(ISampleId childId) {
        Map<SamplePermId, Relationship> relationships = this.getChildrenRelationships();
        return relationships == null ? new Relationship() : relationships.get(childId);
    }

    public void setChildrenRelationships(Map<SamplePermId, Relationship> childrenRelationships) {
        this.childrenRelationships = childrenRelationships;
    }

    @JsonIgnore
    public Sample getContainer() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasContainer()) {
            return this.container;
        }
        throw new NotFetchedException("Container sample has not been fetched.");
    }

    public void setContainer(Sample container) {
        this.container = container;
    }

    @JsonIgnore
    public List<Sample> getComponents() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasComponents()) {
            return this.components;
        }
        throw new NotFetchedException("Component samples have not been fetched.");
    }

    public void setComponents(List<Sample> components) {
        this.components = components;
    }

    @Override
    @JsonIgnore
    public List<DataSet> getDataSets() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasDataSets()) {
            return this.dataSets;
        }
        throw new NotFetchedException("Data sets have not been fetched.");
    }

    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @JsonIgnore
    public List<HistoryEntry> getHistory() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasHistory()) {
            return this.history;
        }
        throw new NotFetchedException("History have not been fetched.");
    }

    public void setHistory(List<HistoryEntry> history) {
        this.history = history;
    }

    @Override
    @JsonIgnore
    public Set<Tag> getTags() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasTags()) {
            return this.tags;
        }
        throw new NotFetchedException("Tags have not been fetched.");
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public Person getModifier() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasModifier()) {
            return this.modifier;
        }
        throw new NotFetchedException("Modifier has not been fetched.");
    }

    public void setModifier(Person modifier) {
        this.modifier = modifier;
    }

    @Override
    @JsonIgnore
    public List<Attachment> getAttachments() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasAttachments()) {
            return this.attachments;
        }
        throw new NotFetchedException("Attachments have not been fetched.");
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.getProperties() != null ? this.getProperties().get(propertyName) : null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, propertyValue);
    }

    @Override
    public Material getMaterialProperty(String propertyName) {
        return this.getMaterialProperties() != null ? this.getMaterialProperties().get(propertyName) : null;
    }

    @Override
    public void setMaterialProperty(String propertyName, Material propertyValue) {
        if (this.materialProperties == null) {
            this.materialProperties = new HashMap<String, Material>();
        }
        this.materialProperties.put(propertyName, propertyValue);
    }

    public String toString() {
        return "Sample " + this.permId;
    }
}

