/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedMethodList(clazz, annotationClass, null);
    }

    private static final List<Method> getAnnotatedMethodList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Method> methods) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Method> list = methods;
        if (list == null) {
            list = new ArrayList<Method>();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotation(annotationClass) == null) continue;
            list.add(method);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedMethodList(superclass, annotationClass, list);
        }
        return list;
    }

    public static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAnnotatedFieldList(clazz, annotationClass, null);
    }

    private static final List<Field> getAnnotatedFieldList(Class<?> clazz, Class<? extends Annotation> annotationClass, List<Field> fields) {
        assert (clazz != null) : "Unspecified class.";
        assert (annotationClass != null) : "Unspecified annotation class.";
        List<Field> list = fields;
        if (list == null) {
            list = new ArrayList<Field>();
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(annotationClass) == null) continue;
            list.add(field);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            return AnnotationUtils.getAnnotatedFieldList(superclass, annotationClass, list);
        }
        return list;
    }

    public static final <A extends Annotation> A tryGetAnnotation(Annotation[] annotations, Class<A> annotationType) {
        assert (annotations != null) : "Unspecified annotations";
        assert (annotationType != null) : "Unspecified annotation type";
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (A)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public static final <A extends Annotation> List<Parameter<A>> getAnnotatedParameters(Method method, Class<A> annotationType) {
        assert (method != null) : "Unspecified method";
        assert (annotationType != null) : "Unspecified annotation type";
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        ArrayList<Parameter<A>> list = new ArrayList<Parameter<A>>();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            A annotationOrNull = AnnotationUtils.tryGetAnnotation(annotations[i], annotationType);
            if (annotationOrNull == null) continue;
            list.add(new Parameter<A>(i, type, annotationOrNull));
        }
        return list;
    }

    public static final class Parameter<A extends Annotation> {
        private final int index;
        private final Class<?> type;
        private final A annotation;

        Parameter(int index, Class<?> type, A annotation) {
            this.index = index;
            this.type = type;
            this.annotation = annotation;
        }

        public final int getIndex() {
            return this.index;
        }

        public final Class<?> getType() {
            return this.type;
        }

        public final A getAnnotation() {
            return this.annotation;
        }
    }
}

