/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.handlers;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class CustomWriterHandler
extends Handler {
    private final Writer write;

    public CustomWriterHandler(Writer write) {
        this.write = write;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String message = this.getFormatter().format(record);
        try {
            this.write.write(message.toCharArray(), 0, message.length());
            this.write.flush();
        }
        catch (IOException e) {
            this.reportError("Error writing log record", e, 1);
        }
    }

    @Override
    public void flush() {
        try {
            this.write.flush();
        }
        catch (IOException e) {
            this.reportError("Error flushing log handler", e, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.write.close();
        }
        catch (IOException e) {
            this.reportError("Error closing log handler", e, 3);
        }
    }
}

