/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import ch.ethz.sis.shared.log.standard.utils.LoggingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Handler;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Logger {
    private final java.util.logging.Logger julLogger;
    private static final String LOG4J_TAG = "[Log4j log]";

    private String decorate(Object message) {
        return "[Log4j log][" + this.getName() + "] " + String.valueOf(message);
    }

    protected Logger(String name) {
        this.julLogger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public String getName() {
        return this.julLogger.getName();
    }

    public void debug(Object message) {
        this.julLogger.log(java.util.logging.Level.FINE, this.decorate(message));
    }

    public void debug(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.FINE, this.decorate(message), t);
    }

    public void info(Object message) {
        this.julLogger.log(java.util.logging.Level.INFO, this.decorate(message));
    }

    public void info(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.INFO, this.decorate(message), t);
    }

    public void warn(Object message) {
        this.julLogger.log(java.util.logging.Level.WARNING, this.decorate(message));
    }

    public void warn(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.WARNING, this.decorate(message), t);
    }

    public void error(Object message) {
        this.julLogger.log(java.util.logging.Level.SEVERE, this.decorate(message));
    }

    public void error(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.SEVERE, this.decorate(message), t);
    }

    public void fatal(Object message) {
        this.julLogger.log(java.util.logging.Level.SEVERE, this.decorate("FATAL: " + String.valueOf(message)));
    }

    public void fatal(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.SEVERE, this.decorate("FATAL: " + String.valueOf(message)), t);
    }

    public boolean isDebugEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.INFO);
    }

    public boolean isErrorEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.SEVERE);
    }

    public void log(Priority priority, Object message, Throwable t) {
        java.util.logging.Level julLevel = LoggingUtils.mapToJULLevel(priority.toInt());
        this.julLogger.log(julLevel, this.decorate(message), t);
    }

    public void log(Priority priority, Object message) {
        this.log(priority, message, null);
    }

    public void setLevel(Level level) {
        this.julLogger.setLevel(ch.systemsx.cisd.common.logging.LoggingUtils.mapToJUL(level));
    }

    public Level getLevel() {
        return ch.systemsx.cisd.common.logging.LoggingUtils.mapFromJUL(this.julLogger.getLevel());
    }

    public Level getEffectiveLevel() {
        java.util.logging.Level root;
        java.util.logging.Logger p = this.julLogger;
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        int hops = 0;
        int MAX_HOPS = 64;
        while (p != null && seen.add(p) && hops++ < MAX_HOPS) {
            java.util.logging.Level lvl = p.getLevel();
            if (lvl != null) {
                return ch.systemsx.cisd.common.logging.LoggingUtils.mapFromJUL(lvl);
            }
            java.util.logging.Logger next = p.getParent();
            if (next == p) break;
            p = next;
        }
        return ch.systemsx.cisd.common.logging.LoggingUtils.mapFromJUL((root = java.util.logging.Logger.getLogger("").getLevel()) != null ? root : java.util.logging.Level.INFO);
    }

    public boolean isEnabledFor(Priority priority) {
        return this.julLogger.isLoggable(LoggingUtils.mapToJULLevel(priority.toInt()));
    }

    public boolean isTraceEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.FINEST);
    }

    public void trace(String message) {
        this.julLogger.log(java.util.logging.Level.FINEST, this.decorate(message));
    }

    public void addHandler(Handler handler) {
        this.julLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.julLogger.removeHandler(handler);
    }

    public void removeAllHandlers() {
        Arrays.stream(this.julLogger.getHandlers()).forEach(this.julLogger::removeHandler);
    }

    public Handler getHandler(String name) {
        return Arrays.stream(this.julLogger.getHandlers()).filter(handler -> handler.getClass().getSimpleName().equals(name)).findFirst().orElse(null);
    }

    public void catching(Throwable ex) {
        String message = ex.getMessage() != null ? ex.getMessage() : "";
        this.log(Level.ERROR, message, ex);
    }

    public Handler[] getHandlers() {
        return this.julLogger.getHandlers();
    }

    public java.util.logging.Logger getJulLogger() {
        return this.julLogger;
    }
}

