/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.AbstractBulkInputStream;
import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IDownloadItemIdSerializer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import ch.ethz.sis.filetransfer.PayloadInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

class ChunkInputStream
extends AbstractBulkInputStream {
    Chunk chunk;
    private HeaderInputStream header;
    private PayloadInputStream payload;
    private ILogger logger;
    private IDownloadItemIdSerializer itemIdSerializer;

    public ChunkInputStream(ILogger logger, IDownloadItemIdSerializer itemIdSerializer, Chunk chunk) throws DownloadException {
        this.chunk = chunk;
        this.logger = logger;
        this.itemIdSerializer = itemIdSerializer;
        this.header = new HeaderInputStream();
        this.payload = new PayloadInputStream(chunk.getPayload(), logger);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.header.read(b, off, len);
        if (n >= 0) {
            return n;
        }
        return this.payload.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.payload.close();
    }

    private class HeaderInputStream
    extends InputStream {
        private ByteBuffer fieldsBuffer;
        private ByteBuffer crcBuffer;

        public HeaderInputStream() throws DownloadException {
            byte[] downloadItemIdBytes = ChunkInputStream.this.itemIdSerializer.serialize(ChunkInputStream.this.chunk.getDownloadItemId());
            byte[] filePathBytes = ChunkInputStream.this.chunk.getFilePath().toString().getBytes();
            if (downloadItemIdBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("Download item id too long too serialize");
            }
            if (filePathBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("File path too long to serialize");
            }
            this.fieldsBuffer = ByteBuffer.allocate(21 + downloadItemIdBytes.length + filePathBytes.length).putInt(ChunkInputStream.this.chunk.getSequenceNumber()).putShort((short)downloadItemIdBytes.length).put((byte)(ChunkInputStream.this.chunk.isDirectory() ? 1 : 0)).putShort((short)filePathBytes.length).putLong(ChunkInputStream.this.chunk.getFileOffset()).putInt(ChunkInputStream.this.chunk.getPayloadLength()).put(downloadItemIdBytes).put(filePathBytes);
            this.fieldsBuffer.rewind();
            CRC32 crc = new CRC32();
            crc.update(this.fieldsBuffer.array());
            this.crcBuffer = ByteBuffer.allocate(8).putLong(crc.getValue());
            this.crcBuffer.rewind();
            if (ChunkInputStream.this.logger.isEnabled(LogLevel.DEBUG)) {
                ChunkInputStream.this.logger.log(this.getClass(), LogLevel.DEBUG, "Header CRC (server): " + Long.toHexString(crc.getValue()));
            }
        }

        @Override
        public int read() throws IOException {
            if (this.fieldsBuffer.hasRemaining()) {
                return 0xFF & this.fieldsBuffer.get();
            }
            if (this.crcBuffer.hasRemaining()) {
                return 0xFF & this.crcBuffer.get();
            }
            return -1;
        }
    }
}

