/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.DefaultRetryProvider;
import ch.ethz.sis.filetransfer.DownloadClientConfig;
import ch.ethz.sis.filetransfer.DownloadClientDownload;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.NullLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DownloadClient {
    private DownloadClientConfig config;
    private Map<IUserSessionId, List<DownloadClientDownload>> downloads = new HashMap<IUserSessionId, List<DownloadClientDownload>>();

    public DownloadClient(DownloadClientConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (config.getServer() == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        if (config.getStore() == null) {
            throw new IllegalArgumentException("Store cannot be null");
        }
        if (config.getDeserializerProvider() == null) {
            throw new IllegalArgumentException("Deserializer provider cannot be null");
        }
        if (config.getLogger() == null) {
            config.setLogger(new NullLogger());
        }
        if (config.getRetryProvider() == null) {
            config.setRetryProvider(new DefaultRetryProvider(config.getLogger()));
        }
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadClientDownload createDownload(IUserSessionId userSessionId) {
        if (userSessionId == null) {
            throw new IllegalArgumentException("User session id cannot be null");
        }
        DownloadClientDownload download = new DownloadClientDownload(this.config, userSessionId);
        Map<IUserSessionId, List<DownloadClientDownload>> map = this.downloads;
        synchronized (map) {
            List<DownloadClientDownload> userDownloads = this.downloads.get(userSessionId);
            if (userDownloads == null) {
                userDownloads = new LinkedList<DownloadClientDownload>();
                this.downloads.put(userSessionId, userDownloads);
            }
            userDownloads.add(download);
        }
        return download;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadClientDownload> getDownloads(IUserSessionId userSessionId) {
        Map<IUserSessionId, List<DownloadClientDownload>> map = this.downloads;
        synchronized (map) {
            List<DownloadClientDownload> userDownloads = this.downloads.get(userSessionId);
            if (userDownloads == null || userDownloads.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(userDownloads);
        }
    }
}

