/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.AbstractBulkInputStream;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

class PayloadInputStream
extends AbstractBulkInputStream {
    private InputStream payload;
    private int length;
    private CRC32 crc;
    private ByteBuffer crcBuffer;
    private ILogger logger;

    public PayloadInputStream(InputStream payLoad, ILogger logger) throws DownloadException {
        this.payload = payLoad;
        this.logger = logger;
        this.crc = new CRC32();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.payload.read(b, off, len);
        if (n >= 0) {
            this.crc.update(b, off, n);
            this.length += n;
            return n;
        }
        if (this.crcBuffer == null) {
            this.crcBuffer = ByteBuffer.allocate(8).putLong(this.crc.getValue());
            this.crcBuffer.rewind();
            if (this.logger.isEnabled(LogLevel.DEBUG)) {
                this.logger.log(this.getClass(), LogLevel.DEBUG, "Payload length (server): " + this.length);
                this.logger.log(this.getClass(), LogLevel.DEBUG, "Payload CRC (server): " + Long.toHexString(this.crc.getValue()));
            }
        }
        if (this.crcBuffer.hasRemaining()) {
            n = Math.min(len, this.crcBuffer.remaining());
            this.crcBuffer.get(b, off, n);
            return n;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.payload.close();
    }
}

