/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.download.DataSetFileDownload;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class DataSetFileDownloadReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private InputStream in;
    private DataSetFileDownload lastDownload;

    public DataSetFileDownloadReader(InputStream in) {
        this.in = in;
    }

    public DataSetFileDownload read() {
        try {
            this.closeLastDownload();
            long headerSize = this.readSize();
            DataSetFile header = (DataSetFile)this.deserializeObject(headerSize);
            final long contentSize = this.readSize();
            InputStream content = new InputStream(){
                long bytesToRead;
                {
                    this.bytesToRead = contentSize;
                }

                @Override
                public int read() throws IOException {
                    this.assertValidInputStream();
                    if (this.bytesToRead > 0L) {
                        --this.bytesToRead;
                        return DataSetFileDownloadReader.this.in.read();
                    }
                    return -1;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    this.assertValidInputStream();
                    int numberOfBytesRead = -1;
                    if (this.bytesToRead > 0L && (numberOfBytesRead = DataSetFileDownloadReader.this.in.read(b, off, (int)Math.min(this.bytesToRead, (long)len))) > 0) {
                        this.bytesToRead -= (long)numberOfBytesRead;
                    }
                    return numberOfBytesRead;
                }

                private void assertValidInputStream() {
                    if (DataSetFileDownloadReader.this.lastDownload.getInputStream() != this) {
                        throw new IllegalStateException("Input stream no longer valid");
                    }
                }
            };
            this.lastDownload = new DataSetFileDownload(header, content);
            return this.lastDownload;
        }
        catch (EOFException e) {
            this.close();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeLastDownload() throws IOException {
        if (this.lastDownload != null) {
            InputStream stream = this.lastDownload.getInputStream();
            while (stream.read() != -1) {
            }
            return;
        }
    }

    private long readSize() throws IOException {
        DataInputStream data = new DataInputStream(this.in);
        return data.readLong();
    }

    private Object deserializeObject(long objectSize) throws IOException, ClassNotFoundException {
        if (objectSize == 0L) {
            return null;
        }
        byte[] bytes = new byte[(int)objectSize];
        int numberOfBytesRead = DataSetFileDownloadReader.read(this.in, bytes);
        if ((long)numberOfBytesRead < objectSize) {
            throw new IllegalStateException("Only " + numberOfBytesRead + " bytes read instead of " + objectSize + " read.");
        }
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    private static int read(InputStream input, byte[] buffer) throws IOException {
        int location;
        int remaining;
        int count;
        for (remaining = buffer.length; remaining > 0 && -1 != (count = input.read(buffer, location = buffer.length - remaining, remaining)); remaining -= count) {
        }
        return buffer.length - remaining;
    }

    public String toString() {
        return new ObjectToString(this).toString();
    }
}

