/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.util.spring;

import com.marathon.util.spring.StreamSupportingRemoteInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationFactory;

public class StreamSupportingRemoteInvocationFactory
implements RemoteInvocationFactory {
    private RemoteInvocationFactory delegate = new DefaultRemoteInvocationFactory();
    private boolean matchOnMethodSignature = true;

    @Override
    public RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
        RemoteInvocation source = this.getDelegate().createRemoteInvocation(methodInvocation);
        if (StreamSupportingRemoteInvocation.isInputStreamInvocation(methodInvocation, this.getMatchOnMethodSignature())) {
            StreamSupportingRemoteInvocation ret = new StreamSupportingRemoteInvocation(source);
            ret.setupInputStreamParam(this.getMatchOnMethodSignature());
            return ret;
        }
        return source;
    }

    public RemoteInvocationFactory getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RemoteInvocationFactory delegate) {
        this.delegate = delegate;
    }

    public boolean getMatchOnMethodSignature() {
        return this.matchOnMethodSignature;
    }

    public void setMatchOnMethodSignature(boolean matchOnMethodSignature) {
        this.matchOnMethodSignature = matchOnMethodSignature;
    }
}

