/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class ChannelSendOperator<T>
extends Mono<Void>
implements Scannable {
    private final Function<Publisher<T>, Publisher<Void>> writeFunction;
    private final Flux<T> source;

    public ChannelSendOperator(Publisher<? extends T> source, Function<Publisher<T>, Publisher<Void>> writeFunction) {
        this.source = Flux.from(source);
        this.writeFunction = writeFunction;
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    public void subscribe(CoreSubscriber<? super Void> actual) {
        this.source.subscribe((CoreSubscriber)new WriteBarrier(actual));
    }

    private class WriteCompletionBarrier
    implements CoreSubscriber<Void>,
    Subscription {
        private final CoreSubscriber<? super Void> completionSubscriber;
        private final WriteBarrier writeBarrier;

        public WriteCompletionBarrier(CoreSubscriber<? super Void> subscriber, WriteBarrier writeBarrier) {
            this.completionSubscriber = subscriber;
            this.writeBarrier = writeBarrier;
        }

        public void connect() {
            this.completionSubscriber.onSubscribe((Subscription)this);
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            this.completionSubscriber.onError(ex);
        }

        public void onComplete() {
            this.completionSubscriber.onComplete();
        }

        public Context currentContext() {
            return this.completionSubscriber.currentContext();
        }

        public void request(long n) {
        }

        public void cancel() {
            this.writeBarrier.cancel();
        }
    }

    private final class WriteBarrier
    implements CoreSubscriber<T>,
    Subscription,
    Publisher<T> {
        private final WriteCompletionBarrier writeCompletionBarrier;
        @Nullable
        private Subscription subscription;
        private boolean readyToWrite = false;
        private boolean beforeFirstEmission = true;
        @Nullable
        private T item;
        @Nullable
        private Throwable error;
        private boolean completed = false;
        @Nullable
        private Subscriber<? super T> writeSubscriber;

        WriteBarrier(CoreSubscriber<? super Void> completionSubscriber) {
            this.writeCompletionBarrier = new WriteCompletionBarrier(completionSubscriber, this);
        }

        public final void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.writeCompletionBarrier.connect();
                s.request(1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onNext(T item) {
            if (this.readyToWrite) {
                this.requiredWriteSubscriber().onNext(item);
                return;
            }
            WriteBarrier writeBarrier = this;
            synchronized (writeBarrier) {
                if (this.readyToWrite) {
                    this.requiredWriteSubscriber().onNext(item);
                } else if (this.beforeFirstEmission) {
                    this.item = item;
                    this.beforeFirstEmission = false;
                    ((Publisher)ChannelSendOperator.this.writeFunction.apply(this)).subscribe((Subscriber)this.writeCompletionBarrier);
                } else {
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                    this.writeCompletionBarrier.onError(new IllegalStateException("Unexpected item."));
                }
            }
        }

        private Subscriber<? super T> requiredWriteSubscriber() {
            Assert.state(this.writeSubscriber != null, "No write subscriber");
            return this.writeSubscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onError(Throwable ex) {
            if (this.readyToWrite) {
                this.requiredWriteSubscriber().onError(ex);
                return;
            }
            WriteBarrier writeBarrier = this;
            synchronized (writeBarrier) {
                if (this.readyToWrite) {
                    this.requiredWriteSubscriber().onError(ex);
                } else if (this.beforeFirstEmission) {
                    this.beforeFirstEmission = false;
                    this.writeCompletionBarrier.onError(ex);
                } else {
                    this.error = ex;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onComplete() {
            if (this.readyToWrite) {
                this.requiredWriteSubscriber().onComplete();
                return;
            }
            WriteBarrier writeBarrier = this;
            synchronized (writeBarrier) {
                if (this.readyToWrite) {
                    this.requiredWriteSubscriber().onComplete();
                } else if (this.beforeFirstEmission) {
                    this.completed = true;
                    this.beforeFirstEmission = false;
                    ((Publisher)ChannelSendOperator.this.writeFunction.apply(this)).subscribe((Subscriber)this.writeCompletionBarrier);
                } else {
                    this.completed = true;
                }
            }
        }

        public Context currentContext() {
            return this.writeCompletionBarrier.currentContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            Subscription s = this.subscription;
            if (s == null) {
                return;
            }
            if (this.readyToWrite) {
                s.request(n);
                return;
            }
            WriteBarrier writeBarrier = this;
            synchronized (writeBarrier) {
                if (this.writeSubscriber != null) {
                    this.readyToWrite = true;
                    if (this.emitCachedSignals()) {
                        return;
                    }
                    if (--n == 0L) {
                        return;
                    }
                }
            }
            s.request(n);
        }

        private boolean emitCachedSignals() {
            if (this.item != null) {
                this.requiredWriteSubscriber().onNext(this.item);
            }
            if (this.error != null) {
                this.requiredWriteSubscriber().onError(this.error);
                return true;
            }
            if (this.completed) {
                this.requiredWriteSubscriber().onComplete();
                return true;
            }
            return false;
        }

        public void cancel() {
            Subscription s = this.subscription;
            if (s != null) {
                this.subscription = null;
                s.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Subscriber<? super T> writeSubscriber) {
            WriteBarrier writeBarrier = this;
            synchronized (writeBarrier) {
                Assert.state(this.writeSubscriber == null, "Only one write subscriber supported");
                this.writeSubscriber = writeSubscriber;
                if (this.error != null || this.completed) {
                    this.writeSubscriber.onSubscribe(Operators.emptySubscription());
                    this.emitCachedSignals();
                } else {
                    this.writeSubscriber.onSubscribe((Subscription)this);
                }
            }
        }
    }
}

