/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadItemNotFoundException;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadStore;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;

public class FileSystemDownloadStore
implements IDownloadStore {
    private ILogger logger;
    private Path storePath;

    public FileSystemDownloadStore(ILogger logger, Path storePath) {
        this.logger = logger;
        this.storePath = storePath;
    }

    protected Path getItemDirectory(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, IDownloadItemId itemId) throws DownloadException {
        String userDir = UUID.nameUUIDFromBytes(userSessionId.getId().getBytes()).toString();
        String downloadDir = UUID.nameUUIDFromBytes(downloadSessionId.getId().getBytes()).toString();
        String itemIdDir = UUID.nameUUIDFromBytes(itemId.getId().getBytes()).toString();
        return this.storePath.resolve(userDir).resolve(downloadDir).resolve(itemIdDir);
    }

    @Override
    public Path getItemPath(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, IDownloadItemId itemId) throws DownloadException {
        File[] itemFiles;
        Path itemDirectory = this.getItemDirectory(userSessionId, downloadSessionId, itemId);
        if (itemDirectory.toFile().exists() && (itemFiles = itemDirectory.toFile().listFiles()).length > 0) {
            return itemFiles[0].toPath();
        }
        throw new DownloadItemNotFoundException("Store does not contain any files for download item id: " + itemId);
    }

    private Path getChunkPath(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, Chunk chunk) throws DownloadException {
        Path chunkPath = this.getItemDirectory(userSessionId, downloadSessionId, chunk.getDownloadItemId()).resolve(chunk.getFilePath());
        if (!this.belongsToStore(chunkPath)) {
            throw new DownloadException("Chunk path does not belong to the store. Chunk path: " + chunkPath + ", store path: " + this.storePath, false);
        }
        return chunkPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void storeChunk(IUserSessionId userSessionId, DownloadSessionId downloadSessionId, Chunk chunk) throws DownloadException {
        Path chunkPath = this.getChunkPath(userSessionId, downloadSessionId, chunk);
        if (chunk.isDirectory()) {
            chunkPath.toFile().mkdirs();
            return;
        }
        chunkPath.toFile().getParentFile().mkdirs();
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        int size = 0;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                ReadableByteChannel chunkChannel = Channels.newChannel(chunk.getPayload());
                try {
                    try (FileChannel fileChannel = FileChannel.open(chunkPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                        fileChannel.position(chunk.getFileOffset());
                        while (chunkChannel.read(buffer) != -1) {
                            buffer.flip();
                            size += fileChannel.write(buffer);
                            buffer.clear();
                        }
                        if (this.logger.isEnabled(LogLevel.DEBUG)) {
                            this.logger.log(this.getClass(), LogLevel.DEBUG, "Chunk " + chunk.getSequenceNumber() + " successfully stored (size: " + size + ")");
                        }
                    }
                    if (chunkChannel == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (chunkChannel == null) throw throwable;
                    chunkChannel.close();
                    throw throwable;
                }
                chunkChannel.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DownloadException("Chunk " + chunk.getSequenceNumber() + " couldn't be stored", e, true);
        }
    }

    private boolean belongsToStore(Path path) {
        while (path != null) {
            if (path.equals(this.storePath)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }
}

