/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2;

import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc1.CommonJ1Statement;
import com.filemaker.jdbc2.CommonJ2Connection;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public abstract class CommonJ2Statement
extends CommonJ1Statement {
    protected Vector batch = null;
    protected int resultSetType = 1004;
    protected int concurrency;

    public CommonJ2Statement(CommonJ2Connection commonJ2Connection) {
        super(commonJ2Connection);
        this.resultSetType = 1004;
        this.concurrency = 1007;
    }

    public CommonJ2Statement(CommonJ2Connection commonJ2Connection, String string) throws SQLException {
        super(commonJ2Connection, string);
    }

    protected boolean useCursorFetch() {
        return this.isSingleSelect() && this.concurrency == 1008;
    }

    public boolean execute() throws SQLException {
        boolean bl = super.execute();
        this.result.setStatement(this);
        return bl;
    }

    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        Object[] objectArray = new Object[]{new String[]{string}, new Object[0], new String[0]};
        this.batch.addElement(objectArray);
    }

    public void clearBatch() throws SQLException {
        this.batch = null;
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        int n = this.batch.size();
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            String[] stringArray = this.m_sqlFragments;
            Object[] objectArray = this.m_binds;
            String[] stringArray2 = this.m_bindTypes;
            for (n2 = 0; n2 < n; ++n2) {
                Object[] objectArray2 = (Object[])this.batch.elementAt(n2);
                this.m_sqlFragments = (String[])objectArray2[0];
                if (this.m_sqlFragments.length == 1) {
                    String string = this.replaceProcessing(this.m_sqlFragments[0]);
                    this.m_sqlFragments = new String[]{string};
                }
                this.m_binds = (Object[])objectArray2[1];
                this.m_bindTypes = (String[])objectArray2[2];
                nArray[n2] = this.executeUpdate();
            }
            this.m_sqlFragments = stringArray;
            this.m_binds = objectArray;
            this.m_bindTypes = stringArray2;
        }
        catch (FMSQLException fMSQLException) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            FMSQLException fMSQLException2 = new FMSQLException("Batch entry stopped.");
            fMSQLException2.setNextException(fMSQLException);
            throw fMSQLException2;
        }
        finally {
            this.batch.removeAllElements();
        }
        return nArray;
    }

    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.connection);
    }

    public int getFetchDirection() throws SQLException {
        throw new FMSQLException("getFetchDirection not implemented", "0A000");
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new FMSQLException("Fetch size must be a value greater than or equal to 0.");
        }
        this.fetchSize = n;
    }

    public void setResultSetConcurrency(int n) throws SQLException {
        this.concurrency = n;
    }

    public void setResultSetType(int n) throws SQLException {
        this.resultSetType = n;
    }

    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        String[] stringArray = null;
        if (this.m_sqlFragments != null) {
            stringArray = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, stringArray, 0, this.m_sqlFragments.length);
        }
        Object[] objectArray = new Object[this.m_binds.length];
        System.arraycopy(this.m_binds, 0, objectArray, 0, this.m_binds.length);
        String[] stringArray2 = new String[this.m_bindTypes.length];
        System.arraycopy(this.m_bindTypes, 0, stringArray2, 0, this.m_bindTypes.length);
        Object[] objectArray2 = new Object[]{stringArray, objectArray, stringArray2};
        this.batch.addElement(objectArray2);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setString(n, array.toString());
    }

    public void setBlob(int n, Blob blob) throws SQLException {
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3;
        char[] cArray = new char[n2];
        try {
            n3 = reader.read(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage());
        }
        this.setString(n, new String(cArray, 0, n3));
    }

    public void setClob(int n, Clob clob) throws SQLException {
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setDate(n, date);
        } else {
            calendar.setTime(date);
            this.setDate(n, new Date(calendar.getTime().getTime()));
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setTime(n, time);
        } else {
            calendar.setTime(time);
            this.setTime(n, new Time(calendar.getTime().getTime()));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setTimestamp(n, timestamp);
        } else {
            calendar.setTime(timestamp);
            this.setTimestamp(n, new Timestamp(calendar.getTime().getTime()));
        }
    }

    public Array getArray(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkIndex(n, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public Blob getBlob(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(int n) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw Driver.notImplemented();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw Driver.notImplemented();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw Driver.notImplemented();
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw Driver.notImplemented();
    }

    protected String[] getSqlFragments() {
        return this.m_sqlFragments;
    }
}

