/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IChunkDeserializer;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadItemIdDeserializer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class DefaultChunkDeserializer
implements IChunkDeserializer {
    private ILogger logger;
    private IDownloadItemIdDeserializer itemIdDeserializer;
    private ByteBuffer sequenceNumberBuffer = ByteBuffer.allocate(4);
    private ByteBuffer downloadItemIdLengthBuffer = ByteBuffer.allocate(2);
    private ByteBuffer isDirectoryBuffer = ByteBuffer.allocate(1);
    private ByteBuffer filePathLengthBuffer = ByteBuffer.allocate(2);
    private ByteBuffer fileOffsetBuffer = ByteBuffer.allocate(8);
    private ByteBuffer payloadLengthBuffer = ByteBuffer.allocate(4);
    private ByteBuffer downloadItemIdBuffer;
    private ByteBuffer filePathBuffer;
    private ByteBuffer payloadBuffer;
    private ByteBuffer sentHeaderChecksumBuffer = ByteBuffer.allocate(8);
    private ByteBuffer sentPayloadChecksumBuffer = ByteBuffer.allocate(8);
    private CRC32 calculatedHeaderChecksum = new CRC32();
    private CRC32 calculatedPayloadChecksum = new CRC32();

    public DefaultChunkDeserializer(ILogger logger, IDownloadItemIdDeserializer itemIdDeserializer) {
        this.logger = logger;
        this.itemIdDeserializer = itemIdDeserializer;
    }

    @Override
    public Chunk deserialize(InputStream stream) throws DownloadException {
        this.calculatedHeaderChecksum.reset();
        this.calculatedPayloadChecksum.reset();
        this.putToBuffer(stream, this.sequenceNumberBuffer, "sequenceNumber", this.sequenceNumberBuffer.capacity(), this.calculatedHeaderChecksum);
        int sequenceNumber = this.sequenceNumberBuffer.getInt();
        this.putToBuffer(stream, this.downloadItemIdLengthBuffer, "downloadItemIdLength", this.downloadItemIdLengthBuffer.capacity(), this.calculatedHeaderChecksum);
        short downloadItemIdLength = this.downloadItemIdLengthBuffer.getShort();
        this.putToBuffer(stream, this.isDirectoryBuffer, "isDirectory", this.isDirectoryBuffer.capacity(), this.calculatedHeaderChecksum);
        boolean isDirectory = this.isDirectoryBuffer.get() > 0;
        this.putToBuffer(stream, this.filePathLengthBuffer, "filePathLength", this.filePathLengthBuffer.capacity(), this.calculatedHeaderChecksum);
        short filePathLength = this.filePathLengthBuffer.getShort();
        this.putToBuffer(stream, this.fileOffsetBuffer, "fileOffset", this.fileOffsetBuffer.capacity(), this.calculatedHeaderChecksum);
        long fileOffset = this.fileOffsetBuffer.getLong();
        this.putToBuffer(stream, this.payloadLengthBuffer, "payloadLength", this.payloadLengthBuffer.capacity(), this.calculatedHeaderChecksum);
        final int payloadLength = this.payloadLengthBuffer.getInt();
        this.downloadItemIdBuffer = this.reuseOrExtendBuffer(this.downloadItemIdBuffer, downloadItemIdLength);
        this.putToBuffer(stream, this.downloadItemIdBuffer, "downloadItemId", downloadItemIdLength, this.calculatedHeaderChecksum);
        IDownloadItemId downloadItemId = this.itemIdDeserializer.deserialize(this.downloadItemIdBuffer);
        this.filePathBuffer = this.reuseOrExtendBuffer(this.filePathBuffer, filePathLength);
        this.putToBuffer(stream, this.filePathBuffer, "filePath", filePathLength, this.calculatedHeaderChecksum);
        String filePath = new String(this.filePathBuffer.array(), this.filePathBuffer.position(), this.filePathBuffer.limit());
        this.putToBuffer(stream, this.sentHeaderChecksumBuffer, "headerChecksum", this.sentHeaderChecksumBuffer.capacity(), null);
        long sentHeaderChecksum = this.sentHeaderChecksumBuffer.getLong();
        if (this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.log(this.getClass(), LogLevel.DEBUG, "Header CRC (client): " + Long.toHexString(this.calculatedHeaderChecksum.getValue()));
        }
        if (this.calculatedHeaderChecksum.getValue() != sentHeaderChecksum) {
            throw new DownloadException("Error in header data detected. Calculated checksum: " + this.calculatedHeaderChecksum.getValue() + ". Sent checksum: " + sentHeaderChecksum, true);
        }
        this.payloadBuffer = this.reuseOrExtendBuffer(this.payloadBuffer, payloadLength);
        this.putToBuffer(stream, this.payloadBuffer, "payload", payloadLength, this.calculatedPayloadChecksum);
        final byte[] payload = this.payloadBuffer.array();
        this.putToBuffer(stream, this.sentPayloadChecksumBuffer, "payloadChecksum", this.sentPayloadChecksumBuffer.capacity(), null);
        long sentPayloadChecksum = this.sentPayloadChecksumBuffer.getLong();
        if (this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.log(this.getClass(), LogLevel.DEBUG, "Payload CRC (client): " + Long.toHexString(this.calculatedPayloadChecksum.getValue()));
        }
        if (this.calculatedPayloadChecksum.getValue() != sentPayloadChecksum) {
            throw new DownloadException("Error in payload data detected. Calculated checksum: " + this.calculatedPayloadChecksum.getValue() + ". Sent checksum: " + sentPayloadChecksum, true);
        }
        return new Chunk(sequenceNumber, downloadItemId, isDirectory, filePath, fileOffset, payloadLength){

            @Override
            public InputStream getPayload() throws DownloadException {
                return new ByteArrayInputStream(payload, 0, payloadLength);
            }
        };
    }

    private ByteBuffer reuseOrExtendBuffer(ByteBuffer buffer, int length) {
        if (buffer != null && buffer.capacity() >= length) {
            return buffer;
        }
        return ByteBuffer.allocate(length);
    }

    private void putToBuffer(InputStream stream, ByteBuffer buffer, String name, int length, CRC32 checksum) throws DownloadException {
        buffer.clear();
        try {
            byte[] bytes = new byte[length];
            int numberOfBytesRead = stream.read(bytes);
            if (numberOfBytesRead < length) {
                throw new DownloadException("Unexpected finish of '" + name + "' field. Actual length: " + numberOfBytesRead + ". Expected length: " + length, true);
            }
            buffer.put(bytes);
            if (checksum != null) {
                checksum.update(bytes);
            }
        }
        catch (IOException iOException) {
            throw new DownloadException("Couldn't read a byte", true);
        }
        buffer.flip();
    }
}

