/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IChunkDeserializer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class DownloadInputStreamReader {
    private ILogger logger;
    private PushbackInputStream downloadStream;
    private IChunkDeserializer chunkDeserializer;

    public DownloadInputStreamReader(ILogger logger, InputStream downloadStream, IChunkDeserializer chunkDeserializer) {
        this.logger = logger;
        this.downloadStream = new PushbackInputStream(downloadStream, 1);
        this.chunkDeserializer = chunkDeserializer;
    }

    public Chunk read() throws DownloadException {
        int b;
        block4: {
            try {
                b = this.downloadStream.read();
                if (b != -1) break block4;
                return null;
            }
            catch (IOException e) {
                throw new DownloadException("Couldn't read chunk: " + e.getMessage(), e, true);
            }
        }
        this.downloadStream.unread(b);
        Chunk chunk = this.chunkDeserializer.deserialize(this.downloadStream);
        if (chunk != null && this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.log(this.getClass(), LogLevel.DEBUG, "Read chunk " + chunk.getSequenceNumber());
        }
        return chunk;
    }

    public void close() throws IOException {
        this.downloadStream.close();
    }
}

