/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.fetchoptions.AttachmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

@JsonObject(value="as.dto.attachment.Attachment")
public class Attachment
implements Serializable,
IDescriptionHolder,
IRegistrationDateHolder,
IRegistratorHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private AttachmentFetchOptions fetchOptions;
    @JsonProperty
    private String fileName;
    @JsonProperty
    private String title;
    @JsonProperty
    private String description;
    @JsonProperty
    private String permlink;
    @JsonProperty
    private String latestVersionPermlink;
    @JsonProperty
    private Integer version;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Attachment previousVersion;
    @JsonProperty
    private byte[] content;

    @JsonIgnore
    public AttachmentFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(AttachmentFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @JsonIgnore
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public String getPermlink() {
        return this.permlink;
    }

    public void setPermlink(String permlink) {
        this.permlink = permlink;
    }

    @JsonIgnore
    public String getLatestVersionPermlink() {
        return this.latestVersionPermlink;
    }

    public void setLatestVersionPermlink(String latestVersionPermlink) {
        this.latestVersionPermlink = latestVersionPermlink;
    }

    @JsonIgnore
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @JsonIgnore
    public Attachment getPreviousVersion() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasPreviousVersion()) {
            return this.previousVersion;
        }
        throw new NotFetchedException("Previous version of attachment  has not been fetched.");
    }

    public void setPreviousVersion(Attachment previousVersion) {
        this.previousVersion = previousVersion;
    }

    @JsonIgnore
    public byte[] getContent() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasContent()) {
            return this.content;
        }
        throw new NotFetchedException("Content has not been fetched.");
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String toString() {
        return "Attachment " + this.fileName + ":" + this.version;
    }
}

