/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.convert;

import ch.systemsx.cisd.base.convert.NativeArrayEncoding;
import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;

public class NativeTaggedArray {
    private static final NativeData.ByteOrder NATIVE_BYTE_ORDER = NativeData.getNativeByteOrder();
    private static final int MAGIC_SIZE = 3;
    private static final int RANK_SIZE = 1;
    private static final int RANK_INDEX = 3;
    private static final int LENGTH_SIZE = 4;
    private static final int LENGTH_INDEX = 4;
    private static final int RANK_1 = 1;

    public static NativeArrayTag tryGetArrayTag(byte[] data) {
        NativeArrayEncoding encodingOrNull = NativeArrayEncoding.tryGetEncoding(data);
        if (encodingOrNull == null) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encodingOrNull.getByteOrder());
        return new NativeArrayTag(encodingOrNull, dimensions);
    }

    public static byte[] toByteArray(float[] data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(float[] data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetFloatEncoding(byteOrder, (byte)4).getMagic();
        assert (magic.length == 3);
        int headerSize = 8;
        byte[] byteArr = new byte[8 + 4 * data.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = 1;
        NativeData.copyIntToByte(new int[]{data.length}, 0, byteArr, 4, 1, byteOrder);
        NativeData.copyFloatToByte(data, 0, byteArr, 8, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] toByteArray(MDFloatArray data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(MDFloatArray data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetFloatEncoding(byteOrder, (byte)4).getMagic();
        assert (magic.length == 3);
        byte rank = (byte)data.rank();
        int headerSize = 4 + rank * 4;
        float[] flatDataArray = data.getAsFlatArray();
        byte[] byteArr = new byte[headerSize + 4 * flatDataArray.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = rank;
        NativeData.copyIntToByte(data.dimensions(), 0, byteArr, 4, (int)rank, byteOrder);
        NativeData.copyFloatToByte(flatDataArray, 0, byteArr, headerSize, flatDataArray.length, byteOrder);
        return byteArr;
    }

    public static float[] tryToFloatArray1D(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isInteger() || encoding.getSizeInBytes() != 4) {
            return null;
        }
        byte rank = data[3];
        if (rank != 1) {
            return null;
        }
        int[] dimensions = new int[1];
        NativeData.copyByteToInt(data, 4, dimensions, 0, 1, encoding.getByteOrder());
        if (dimensions[0] * 4 + 4 + 4 != data.length) {
            return null;
        }
        float[] floatData = new float[dimensions[0]];
        NativeData.copyByteToFloat(data, 8, floatData, 0, floatData.length, encoding.getByteOrder());
        return floatData;
    }

    public static MDFloatArray tryToFloatArray(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isInteger() || encoding.getSizeInBytes() != 4) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encoding.getByteOrder());
        int length = MDAbstractArray.getLength(dimensions);
        int headerSize = 4 + rank * 4;
        if (length * 4 + headerSize != data.length) {
            return null;
        }
        float[] intData = new float[length];
        NativeData.copyByteToFloat(data, headerSize, intData, 0, intData.length, encoding.getByteOrder());
        return new MDFloatArray(intData, dimensions);
    }

    public static byte[] toByteArray(double[] data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(double[] data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetFloatEncoding(byteOrder, (byte)8).getMagic();
        assert (magic.length == 3);
        int headerSize = 8;
        byte[] byteArr = new byte[8 + 8 * data.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = 1;
        NativeData.copyIntToByte(new int[]{data.length}, 0, byteArr, 4, 1, byteOrder);
        NativeData.copyDoubleToByte(data, 0, byteArr, 8, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] toByteArray(MDDoubleArray data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(MDDoubleArray data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetFloatEncoding(byteOrder, (byte)8).getMagic();
        assert (magic.length == 3);
        byte rank = (byte)data.rank();
        int headerSize = 4 + rank * 4;
        double[] flatDataArray = data.getAsFlatArray();
        byte[] byteArr = new byte[headerSize + 8 * flatDataArray.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = rank;
        NativeData.copyIntToByte(data.dimensions(), 0, byteArr, 4, (int)rank, byteOrder);
        NativeData.copyDoubleToByte(flatDataArray, 0, byteArr, headerSize, flatDataArray.length, byteOrder);
        return byteArr;
    }

    public static double[] tryToDoubleArray1D(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isInteger() || encoding.getSizeInBytes() != 8) {
            return null;
        }
        byte rank = data[3];
        if (rank != 1) {
            return null;
        }
        int[] dimensions = new int[1];
        NativeData.copyByteToInt(data, 4, dimensions, 0, 1, encoding.getByteOrder());
        if (dimensions[0] * 8 + 4 + 4 != data.length) {
            return null;
        }
        double[] doubleData = new double[dimensions[0]];
        NativeData.copyByteToDouble(data, 8, doubleData, 0, doubleData.length, encoding.getByteOrder());
        return doubleData;
    }

    public static MDDoubleArray tryToDoubleArray(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isInteger() || encoding.getSizeInBytes() != 8) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encoding.getByteOrder());
        int length = MDAbstractArray.getLength(dimensions);
        int headerSize = 4 + rank * 4;
        if (length * 8 + headerSize != data.length) {
            return null;
        }
        double[] intData = new double[length];
        NativeData.copyByteToDouble(data, headerSize, intData, 0, intData.length, encoding.getByteOrder());
        return new MDDoubleArray(intData, dimensions);
    }

    public static byte[] toByteArray(short[] data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(short[] data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)2).getMagic();
        assert (magic.length == 3);
        int headerSize = 8;
        byte[] byteArr = new byte[8 + 2 * data.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = 1;
        NativeData.copyIntToByte(new int[]{data.length}, 0, byteArr, 4, 1, byteOrder);
        NativeData.copyShortToByte(data, 0, byteArr, 8, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] toByteArray(MDShortArray data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(MDShortArray data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)2).getMagic();
        assert (magic.length == 3);
        byte rank = (byte)data.rank();
        int headerSize = 4 + rank * 4;
        short[] flatDataArray = data.getAsFlatArray();
        byte[] byteArr = new byte[headerSize + 2 * flatDataArray.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = rank;
        NativeData.copyIntToByte(data.dimensions(), 0, byteArr, 4, (int)rank, byteOrder);
        NativeData.copyShortToByte(flatDataArray, 0, byteArr, headerSize, flatDataArray.length, byteOrder);
        return byteArr;
    }

    public static short[] tryToShortArray1D(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 2) {
            return null;
        }
        byte rank = data[3];
        if (rank != 1) {
            return null;
        }
        int[] dimensions = new int[1];
        NativeData.copyByteToInt(data, 4, dimensions, 0, 1, encoding.getByteOrder());
        if (dimensions[0] * 2 + 4 + 4 != data.length) {
            return null;
        }
        short[] shortData = new short[dimensions[0]];
        NativeData.copyByteToShort(data, 8, shortData, 0, shortData.length, encoding.getByteOrder());
        return shortData;
    }

    public static MDShortArray tryToShortArray(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 2) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encoding.getByteOrder());
        int length = MDAbstractArray.getLength(dimensions);
        int headerSize = 4 + rank * 4;
        if (length * 2 + headerSize != data.length) {
            return null;
        }
        short[] intData = new short[length];
        NativeData.copyByteToShort(data, headerSize, intData, 0, intData.length, encoding.getByteOrder());
        return new MDShortArray(intData, dimensions);
    }

    public static byte[] toByteArray(int[] data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(int[] data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)4).getMagic();
        assert (magic.length == 3);
        int headerSize = 8;
        byte[] byteArr = new byte[8 + 4 * data.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = 1;
        NativeData.copyIntToByte(new int[]{data.length}, 0, byteArr, 4, 1, byteOrder);
        NativeData.copyIntToByte(data, 0, byteArr, 8, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] toByteArray(MDIntArray data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(MDIntArray data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)4).getMagic();
        assert (magic.length == 3);
        byte rank = (byte)data.rank();
        int headerSize = 4 + rank * 4;
        int[] flatDataArray = data.getAsFlatArray();
        byte[] byteArr = new byte[headerSize + 4 * flatDataArray.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = rank;
        NativeData.copyIntToByte(data.dimensions(), 0, byteArr, 4, (int)rank, byteOrder);
        NativeData.copyIntToByte(flatDataArray, 0, byteArr, headerSize, flatDataArray.length, byteOrder);
        return byteArr;
    }

    public static int[] tryToIntArray1D(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 4) {
            return null;
        }
        byte rank = data[3];
        if (rank != 1) {
            return null;
        }
        int[] dimensions = new int[1];
        NativeData.copyByteToInt(data, 4, dimensions, 0, 1, encoding.getByteOrder());
        if (dimensions[0] * 4 + 4 + 4 != data.length) {
            return null;
        }
        int[] intData = new int[dimensions[0]];
        NativeData.copyByteToInt(data, 8, intData, 0, intData.length, encoding.getByteOrder());
        return intData;
    }

    public static MDIntArray tryToIntArray(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 4) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encoding.getByteOrder());
        int length = MDAbstractArray.getLength(dimensions);
        int headerSize = 4 + rank * 4;
        if (length * 4 + headerSize != data.length) {
            return null;
        }
        int[] intData = new int[length];
        NativeData.copyByteToInt(data, headerSize, intData, 0, intData.length, encoding.getByteOrder());
        return new MDIntArray(intData, dimensions);
    }

    public static byte[] toByteArray(long[] data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(long[] data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)8).getMagic();
        assert (magic.length == 3);
        int headerSize = 8;
        byte[] byteArr = new byte[8 + 8 * data.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = 1;
        NativeData.copyIntToByte(new int[]{data.length}, 0, byteArr, 4, 1, byteOrder);
        NativeData.copyLongToByte(data, 0, byteArr, 8, data.length, byteOrder);
        return byteArr;
    }

    public static byte[] toByteArray(MDLongArray data) {
        return NativeTaggedArray.toByteArray(data, NATIVE_BYTE_ORDER);
    }

    public static byte[] toByteArray(MDLongArray data, NativeData.ByteOrder byteOrder) {
        byte[] magic = NativeArrayEncoding.tryGetIntEncoding(byteOrder, (byte)8).getMagic();
        assert (magic.length == 3);
        byte rank = (byte)data.rank();
        int headerSize = 4 + rank * 4;
        long[] flatDataArray = data.getAsFlatArray();
        byte[] byteArr = new byte[headerSize + 8 * flatDataArray.length];
        System.arraycopy(magic, 0, byteArr, 0, 3);
        byteArr[3] = rank;
        NativeData.copyIntToByte(data.dimensions(), 0, byteArr, 4, (int)rank, byteOrder);
        NativeData.copyLongToByte(flatDataArray, 0, byteArr, headerSize, flatDataArray.length, byteOrder);
        return byteArr;
    }

    public static long[] tryToLongArray1D(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 8) {
            return null;
        }
        byte rank = data[3];
        if (rank != 1) {
            return null;
        }
        int[] dimensions = new int[1];
        NativeData.copyByteToInt(data, 4, dimensions, 0, 1, encoding.getByteOrder());
        if (dimensions[0] * 8 + 4 + 4 != data.length) {
            return null;
        }
        long[] longData = new long[dimensions[0]];
        NativeData.copyByteToLong(data, 8, longData, 0, longData.length, encoding.getByteOrder());
        return longData;
    }

    public static MDLongArray tryToLongArray(byte[] data) {
        NativeArrayEncoding encoding = NativeArrayEncoding.tryGetEncoding(data);
        if (encoding == null || encoding.isFloatingPoint() || encoding.getSizeInBytes() != 8) {
            return null;
        }
        byte rank = data[3];
        int[] dimensions = new int[rank];
        NativeData.copyByteToInt(data, 4, dimensions, 0, (int)rank, encoding.getByteOrder());
        int length = MDAbstractArray.getLength(dimensions);
        int headerSize = 4 + rank * 4;
        if (length * 8 + headerSize != data.length) {
            return null;
        }
        long[] longData = new long[length];
        NativeData.copyByteToLong(data, headerSize, longData, 0, longData.length, encoding.getByteOrder());
        return new MDLongArray(longData, dimensions);
    }

    public static class NativeArrayTag {
        private final NativeArrayEncoding encoding;
        private final int[] dimensions;

        NativeArrayTag(NativeArrayEncoding encoding, int[] dimensions) {
            this.encoding = encoding;
            this.dimensions = dimensions;
        }

        public NativeArrayEncoding getEncoding() {
            return this.encoding;
        }

        public int[] getDimensions() {
            return this.dimensions;
        }
    }
}

