/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.unix;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.FileLinkType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Unix {
    private static Integer gid = null;
    private static Integer uid = null;
    private static Map<String, Integer> uidByUserName = new HashMap<String, Integer>();
    private static Map<String, Integer> gidByGroupName = new HashMap<String, Integer>();
    private static Integer euid = null;
    private static Map<Integer, String> userNameByUid = new HashMap<Integer, String>();
    private static Map<Integer, String> groupNameByGid = new HashMap<Integer, String>();

    private Unix() {
    }

    public static boolean isOperational() {
        boolean isIdCommandLineToolAvailable;
        boolean isPosixFileSystem = File.separatorChar == '/';
        try {
            Unix.getUid();
            isIdCommandLineToolAvailable = true;
        }
        catch (Throwable t) {
            isIdCommandLineToolAvailable = false;
        }
        return isPosixFileSystem && isIdCommandLineToolAvailable;
    }

    public static int getGid() {
        if (gid == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -g -r");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                gid = Integer.parseInt(output);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return gid;
    }

    public static int getUid() throws IOExceptionUnchecked {
        if (uid == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -u -r");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                uid = Integer.parseInt(output);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return uid;
    }

    public static final int getUidForUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        if (uidByUserName.get(userName) == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -u " + userName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                int uid = Integer.parseInt(output);
                uidByUserName.put(userName, uid);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return uidByUserName.get(userName);
    }

    public static final int getGidForGroupName(String groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName");
        }
        if (gidByGroupName.get(groupName) == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -g " + groupName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                int uid = Integer.parseInt(output);
                gidByGroupName.put(groupName, uid);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return gidByGroupName.get(groupName);
    }

    public static int getEuid() {
        if (euid == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -u");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                euid = Integer.parseInt(output);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return euid;
    }

    public static final int getEgid() {
        return Unix.getGid();
    }

    public static void setOwner(String path, int userId, int groupId) {
        try {
            Files.setAttribute(Path.of(path, new String[0]), "unix:uid", userId, new LinkOption[0]);
            Files.setAttribute(Path.of(path, new String[0]), "unix:gid", groupId, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static final void setLinkOwner(String linkName, int uid, int gid) throws IOExceptionUnchecked {
        try {
            Files.setAttribute(Path.of(linkName, new String[0]), "unix:uid", uid, LinkOption.NOFOLLOW_LINKS);
            Files.setAttribute(Path.of(linkName, new String[0]), "unix:gid", gid, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static final void setLinkOwner(String linkName, Password user) throws IOExceptionUnchecked {
        Unix.setLinkOwner(linkName, user.getUid(), user.getGid());
    }

    public static final void setOwner(String fileName, Password user) throws IOExceptionUnchecked {
        Unix.setOwner(fileName, user.getUid(), user.getGid());
    }

    public static int getUid(String path, boolean followLinks) {
        try {
            if (followLinks) {
                return (Integer)Files.getAttribute(Path.of(path, new String[0]), "unix:uid", new LinkOption[0]);
            }
            return (Integer)Files.getAttribute(Path.of(path, new String[0]), "unix:uid", LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static int getUid(String path) {
        return Unix.getUid(path, true);
    }

    public static int getGid(String path, boolean followLinks) {
        try {
            if (followLinks) {
                return (Integer)Files.getAttribute(Path.of(path, new String[0]), "unix:gid", new LinkOption[0]);
            }
            return (Integer)Files.getAttribute(Path.of(path, new String[0]), "unix:gid", LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static int getGid(String path) {
        return Unix.getGid(path, true);
    }

    public static String tryGetUserNameForUid(int uid) {
        if (userNameByUid.get(uid) == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -un " + uid);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                userNameByUid.put(uid, output);
                uidByUserName.put(output, uid);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return userNameByUid.get(uid);
    }

    public static String tryGetGroupNameForGid(int gid) {
        if (groupNameByGid.get(gid) == null) {
            try {
                Process process = Runtime.getRuntime().exec("id -gn " + gid);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                groupNameByGid.put(gid, output);
                gidByGroupName.put(output, gid);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        return groupNameByGid.get(gid);
    }

    public static Time getSystemTime() {
        return Time.getInstance();
    }

    public static String tryReadSymbolicLink(String absolutePath) {
        Stat stat = Unix.tryGetLinkInfo(absolutePath);
        return stat.isSymbolicLink() ? stat.tryGetSymbolicLink() : null;
    }

    public static Password tryGetUserByName(String username) throws IOExceptionUnchecked {
        int uid = Unix.getUidForUserName(username);
        int gid = Unix.getGidForGroupName(username);
        Password password = new Password(username, uid, gid);
        return password;
    }

    private static short getNumericAccessMode(Set<PosixFilePermission> permissions) {
        short posixPermissions = 0;
        for (PosixFilePermission permission : permissions) {
            switch (permission) {
                case OWNER_READ: {
                    posixPermissions = (short)(posixPermissions | 0x100);
                    break;
                }
                case OWNER_WRITE: {
                    posixPermissions = (short)(posixPermissions | 0x80);
                    break;
                }
                case OWNER_EXECUTE: {
                    posixPermissions = (short)(posixPermissions | 0x40);
                    break;
                }
                case GROUP_READ: {
                    posixPermissions = (short)(posixPermissions | 0x20);
                    break;
                }
                case GROUP_WRITE: {
                    posixPermissions = (short)(posixPermissions | 0x10);
                    break;
                }
                case GROUP_EXECUTE: {
                    posixPermissions = (short)(posixPermissions | 8);
                    break;
                }
                case OTHERS_READ: {
                    posixPermissions = (short)(posixPermissions | 4);
                    break;
                }
                case OTHERS_WRITE: {
                    posixPermissions = (short)(posixPermissions | 2);
                    break;
                }
                case OTHERS_EXECUTE: {
                    posixPermissions = (short)(posixPermissions | 1);
                }
            }
        }
        return posixPermissions;
    }

    private static Set<PosixFilePermission> getFilePermissionsMode(short permissions) {
        HashSet<PosixFilePermission> posixPermissions = new HashSet<PosixFilePermission>();
        if ((permissions & 0x100) != 0) {
            posixPermissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((permissions & 0x80) != 0) {
            posixPermissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((permissions & 0x40) != 0) {
            posixPermissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((permissions & 0x20) != 0) {
            posixPermissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((permissions & 0x10) != 0) {
            posixPermissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((permissions & 8) != 0) {
            posixPermissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((permissions & 4) != 0) {
            posixPermissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((permissions & 2) != 0) {
            posixPermissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((permissions & 1) != 0) {
            posixPermissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return posixPermissions;
    }

    public static Stat getLinkInfo(String absolutePath) {
        return Unix.getLinkInfo(absolutePath, true);
    }

    public static Stat getLinkInfo(String pathAsString, boolean readSymbolicLinkTarget) {
        try {
            int gid;
            int uid;
            FileLinkType linkType;
            short permissions;
            if (pathAsString == null) {
                throw new NullPointerException("linkName");
            }
            Path path = Path.of(pathAsString, new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                return null;
            }
            PosixFileAttributes attrs = null;
            if (readSymbolicLinkTarget && Files.exists(path, new LinkOption[0])) {
                permissions = Unix.getNumericAccessMode(Files.getPosixFilePermissions(path, new LinkOption[0]));
                attrs = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
                linkType = Files.isSymbolicLink(path) ? FileLinkType.SYMLINK : (Files.isDirectory(path, new LinkOption[0]) ? FileLinkType.DIRECTORY : (Files.isRegularFile(path, new LinkOption[0]) ? FileLinkType.REGULAR_FILE : FileLinkType.OTHER));
                uid = Unix.getUid(pathAsString);
                gid = Unix.getGid(pathAsString);
            } else {
                permissions = Unix.getNumericAccessMode(Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS));
                attrs = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                linkType = Files.isSymbolicLink(path) ? FileLinkType.SYMLINK : (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? FileLinkType.DIRECTORY : (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS) ? FileLinkType.REGULAR_FILE : FileLinkType.OTHER));
                uid = Unix.getUid(pathAsString, false);
                gid = Unix.getGid(pathAsString, false);
            }
            FileTime lastModified = attrs.lastModifiedTime();
            FileTime lastAccessed = attrs.lastAccessTime();
            String symbolicLinkOrNull = null;
            if (linkType == FileLinkType.SYMLINK && readSymbolicLinkTarget) {
                symbolicLinkOrNull = Files.readSymbolicLink(path).toString();
            }
            long size = attrs.size();
            return new Stat(path, permissions, linkType, lastModified, lastAccessed, uid, gid, symbolicLinkOrNull, size);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static Stat tryGetLinkInfo(String pathAsString) {
        return Unix.getLinkInfo(pathAsString, true);
    }

    public static Stat tryGetFileInfo(String absolutePath) {
        return Unix.getFileInfo(absolutePath, true);
    }

    public static Stat getFileInfo(String pathAsString) {
        return Unix.getFileInfo(pathAsString, true);
    }

    public static Stat getFileInfo(String pathAsString, boolean readSymbolicLinkTarget) throws IOExceptionUnchecked {
        try {
            if (pathAsString == null) {
                throw new NullPointerException("linkName");
            }
            Path path = Path.of(pathAsString, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            short permissions = Unix.getNumericAccessMode(Files.getPosixFilePermissions(path, new LinkOption[0]));
            PosixFileAttributes attrs = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
            FileLinkType linkType = attrs.isSymbolicLink() ? FileLinkType.SYMLINK : (attrs.isDirectory() ? FileLinkType.DIRECTORY : (attrs.isRegularFile() ? FileLinkType.REGULAR_FILE : FileLinkType.OTHER));
            FileTime lastModified = attrs.lastModifiedTime();
            FileTime lastAccessed = attrs.lastAccessTime();
            int uid = Unix.getUid(pathAsString);
            int gid = Unix.getGid(pathAsString);
            String symbolicLinkOrNull = null;
            if (linkType == FileLinkType.SYMLINK && readSymbolicLinkTarget) {
                symbolicLinkOrNull = Files.readSymbolicLink(path).toString();
            }
            long size = attrs.size();
            return new Stat(path, permissions, linkType, lastModified, lastAccessed, uid, gid, symbolicLinkOrNull, size);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static Set<PosixFilePermission> getPermissions(String path) throws IOExceptionUnchecked {
        try {
            return Files.getPosixFilePermissions(Path.of(path, new String[0]), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static void setAccessMode(String path, Set<PosixFilePermission> permissions) throws IOExceptionUnchecked {
        try {
            Files.setPosixFilePermissions(Path.of(path, new String[0]), permissions);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static void setAccessMode(String path, short mode) throws IOExceptionUnchecked {
        Set<PosixFilePermission> permissions = Unix.getFilePermissionsMode(mode);
        Unix.setAccessMode(path, permissions);
    }

    public static void setAccessMode777(String path) throws IOExceptionUnchecked {
        try {
            Files.setPosixFilePermissions(Path.of(path, new String[0]), Set.of(PosixFilePermission.values()));
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public static boolean isSymbolicLink(String absolutePath) {
        return Files.isSymbolicLink(Path.of(absolutePath, new String[0]));
    }

    public static final void createHardLink(String fileName, String linkName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        Unix.link(fileName, linkName);
    }

    public static final void createSymbolicLink(String fileName, String linkName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        Unix.symlink(fileName, linkName);
    }

    public static final void symlink(String fileName, String linkName) throws IOExceptionUnchecked {
        try {
            Path file = Path.of(fileName, new String[0]);
            Path link = Path.of(linkName, new String[0]);
            Files.createSymbolicLink(link, file, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new IOExceptionUnchecked(exception);
        }
    }

    public static final void link(String fileName, String linkName) throws IOExceptionUnchecked {
        try {
            Path file = Path.of(fileName, new String[0]);
            Path link = Path.of(linkName, new String[0]);
            Files.createLink(link, file);
        }
        catch (IOException exception) {
            throw new IOExceptionUnchecked(exception);
        }
    }

    public static final class Password {
        private final String userName;
        private final int uid;
        private final int gid;

        Password(String userName, int uid, int gid) {
            this.userName = userName;
            this.uid = uid;
            this.gid = gid;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getUid() {
            return this.uid;
        }

        public int getGid() {
            return this.gid;
        }
    }

    public static final class Time {
        private final long secs;
        private final long nanos;

        public static Time getInstance() {
            Instant now = Instant.now();
            return new Time(now);
        }

        private Time(Instant now) {
            this(now.getEpochSecond(), now.getNano());
        }

        private Time(FileTime fileTime) {
            this(fileTime.toInstant().getEpochSecond(), fileTime.toInstant().getNano());
        }

        private Time(long secs, long nanos) {
            this.secs = secs;
            this.nanos = nanos;
        }

        public long getSecs() {
            return this.secs;
        }

        public long getNanoSecPart() {
            return this.nanos;
        }

        public long getMicroSecPart() {
            if (this.nanos % 1000L >= 500L) {
                return this.nanos / 1000L + 1L;
            }
            return this.nanos / 1000L;
        }

        public long getMilliSecPart() {
            if (this.nanos % 1000000L >= 500000L) {
                return this.nanos / 1000000L + 1L;
            }
            return this.nanos / 1000000L;
        }

        public long getMillis() {
            return this.secs * 1000L + this.getMilliSecPart();
        }

        public String toString() {
            return "Time [secs=" + this.secs + ", nanos=" + this.nanos + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.nanos ^ this.nanos >>> 32);
            result = 31 * result + (int)(this.secs ^ this.secs >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Time other = (Time)obj;
            if (this.nanos != other.nanos) {
                return false;
            }
            return this.secs == other.secs;
        }
    }

    public static class Stat {
        private final Path path;
        private final short permissions;
        private final FileLinkType linkType;
        private final Time lastModified;
        private final Time lastAccessed;
        private final int uid;
        private final int gid;
        private final String symbolicLinkOrNull;
        private final long size;

        public Stat(Path path, short permissions, FileLinkType linkType, FileTime lastModified, FileTime lastAccessed, int uid, int gid, String symbolicLinkOrNull, long size) {
            this.path = path;
            this.permissions = permissions;
            this.linkType = linkType;
            this.lastModified = new Time(lastModified);
            this.lastAccessed = new Time(lastAccessed);
            this.uid = uid;
            this.gid = gid;
            this.symbolicLinkOrNull = symbolicLinkOrNull;
            this.size = size;
        }

        public short getPermissions() {
            return this.permissions;
        }

        public FileLinkType getLinkType() {
            return this.linkType;
        }

        public long getLastAccess() {
            return this.lastAccessed.getSecs();
        }

        public Time getLastAccessTime() {
            return this.lastAccessed;
        }

        public long getLastModified() {
            return this.lastModified.getSecs();
        }

        public Time getLastModifiedTime() {
            return this.lastModified;
        }

        public int getUid() {
            return this.uid;
        }

        public int getGid() {
            return this.gid;
        }

        public String tryGetSymbolicLink() {
            return this.symbolicLinkOrNull;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isSymbolicLink() {
            return this.symbolicLinkOrNull != null;
        }

        public int getNumberOfHardLinks() throws IOException {
            Number count = (Number)Files.getAttribute(this.path, "unix:nlink", LinkOption.NOFOLLOW_LINKS);
            return count.intValue();
        }
    }
}

