/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging.ext;

import ch.systemsx.cisd.common.logging.ext.ExtendedLogRecord;
import ch.systemsx.cisd.common.logging.ext.LoggingUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternFormatter
extends Formatter {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final Pattern LOGGER_PATTERN = Pattern.compile("%logger(?:\\{(\\d+)})?");
    public static final Pattern DATE_PATTERN = Pattern.compile("%d(?:\\{([^}]+)})?");
    public static final Pattern LEVEL_PATTERN = Pattern.compile("%(-?\\d+)?(p|level)");
    private final String messagePattern;

    public PatternFormatter(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    @Override
    public String format(LogRecord record) {
        String formatted = this.messagePattern;
        if (formatted == null || formatted.isEmpty()) {
            return record.getMessage();
        }
        formatted = this.formatDate(record, formatted);
        if ((formatted = PatternFormatter.formatLevel(record, formatted)).contains("%c")) {
            formatted = formatted.replace("%c", record.getLoggerName());
        }
        if (formatted.contains("%logger")) {
            formatted = PatternFormatter.formatLogger(record, formatted);
        }
        if (formatted.contains("%t")) {
            formatted = PatternFormatter.formatThreadName(record, formatted);
        }
        if (formatted.contains("%msg")) {
            formatted = formatted.replace("%msg", record.getMessage() != null ? this.formatMessage(record) : "");
        }
        if (formatted.contains("%m")) {
            formatted = formatted.replace("%m", record.getMessage() != null ? this.formatMessage(record) : "");
        }
        if (formatted.contains("%n")) {
            formatted = formatted.replace("%n", System.lineSeparator());
        }
        formatted = PatternFormatter.formatExceptionIfAvailable(record, formatted);
        return formatted;
    }

    private static String formatExceptionIfAvailable(LogRecord record, String formatted) {
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            formatted = (String)formatted + sw.toString();
        }
        return formatted;
    }

    private static String formatThreadName(LogRecord record, String formatted) {
        String threadName = record instanceof ExtendedLogRecord ? ((ExtendedLogRecord)record).getThreadName() : Thread.currentThread().getName();
        formatted = formatted.replace("%t", threadName);
        return formatted;
    }

    private static String formatLogger(LogRecord record, String formatted) {
        Matcher loggerMatcher = LOGGER_PATTERN.matcher(formatted);
        StringBuilder loggerBuffer = new StringBuilder();
        while (loggerMatcher.find()) {
            String loggerName = PatternFormatter.getLoggerName(record, loggerMatcher);
            loggerMatcher.appendReplacement(loggerBuffer, Matcher.quoteReplacement(loggerName));
        }
        loggerMatcher.appendTail(loggerBuffer);
        formatted = loggerBuffer.toString();
        return formatted;
    }

    private static String getLoggerName(LogRecord record, Matcher loggerMatcher) {
        String widthStr = loggerMatcher.group(1);
        String loggerName = record.getLoggerName();
        if (widthStr != null) {
            try {
                int width = Integer.parseInt(widthStr);
                if (loggerName.length() > width) {
                    loggerName = loggerName.substring(loggerName.length() - width);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return loggerName;
    }

    private String formatDate(LogRecord record, String formatted) {
        Matcher dateMatcher = DATE_PATTERN.matcher(formatted);
        StringBuilder dateBuffer = new StringBuilder();
        while (dateMatcher.find()) {
            String dateFormatStr = dateMatcher.group(1);
            SimpleDateFormat sdf = new SimpleDateFormat(Objects.requireNonNullElse(dateFormatStr, DEFAULT_DATE_PATTERN));
            String dateStr = sdf.format(new Date(record.getMillis()));
            dateMatcher.appendReplacement(dateBuffer, Matcher.quoteReplacement(dateStr));
        }
        dateMatcher.appendTail(dateBuffer);
        formatted = dateBuffer.toString();
        return formatted;
    }

    private static String formatLevel(LogRecord record, String formatted) {
        Matcher levelMatcher = LEVEL_PATTERN.matcher(formatted);
        StringBuilder levelBuffer = new StringBuilder();
        while (levelMatcher.find()) {
            String widthStr = levelMatcher.group(1);
            int width = 0;
            boolean leftAlign = false;
            if (widthStr != null) {
                if (widthStr.startsWith("-")) {
                    leftAlign = true;
                    widthStr = widthStr.substring(1);
                }
                try {
                    width = Integer.parseInt(widthStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String level = LoggingUtils.mapFromJUL(record.getLevel()).getName();
            String replacement = width > 0 ? (leftAlign ? String.format("%-" + width + "s", level) : String.format("%" + width + "s", level)) : level;
            levelMatcher.appendReplacement(levelBuffer, Matcher.quoteReplacement(replacement));
        }
        levelMatcher.appendTail(levelBuffer);
        formatted = levelBuffer.toString();
        return formatted;
    }
}

