/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import ch.systemsx.cisd.common.logging.ext.LoggingUtils;
import java.util.Arrays;
import java.util.logging.Handler;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Logger {
    private final java.util.logging.Logger julLogger;

    protected Logger(String name) {
        this.julLogger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public String getName() {
        return this.julLogger.getName();
    }

    public void debug(Object message) {
        this.julLogger.log(java.util.logging.Level.FINE, String.valueOf(message));
    }

    public void debug(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.FINE, String.valueOf(message), t);
    }

    public void info(Object message) {
        this.julLogger.log(java.util.logging.Level.INFO, String.valueOf(message));
    }

    public void info(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.INFO, String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.julLogger.log(java.util.logging.Level.WARNING, String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.WARNING, String.valueOf(message), t);
    }

    public void error(Object message) {
        this.julLogger.log(java.util.logging.Level.SEVERE, String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.SEVERE, String.valueOf(message), t);
    }

    public void fatal(Object message) {
        this.julLogger.log(java.util.logging.Level.SEVERE, "FATAL: " + String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        this.julLogger.log(java.util.logging.Level.SEVERE, "FATAL: " + String.valueOf(message), t);
    }

    public boolean isDebugEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.INFO);
    }

    public boolean isErrorEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.SEVERE);
    }

    public void log(Priority priority, Object message, Throwable t) {
        java.util.logging.Level julLevel = LoggingUtils.mapToJULLevel(priority.toInt());
        this.julLogger.log(julLevel, String.valueOf(message), t);
    }

    public void log(Priority priority, Object message) {
        this.log(priority, message, null);
    }

    public void setLevel(Level level) {
        this.julLogger.setLevel(LoggingUtils.mapToJUL(level));
    }

    public Level getLevel() {
        return LoggingUtils.mapFromJUL(this.julLogger.getLevel());
    }

    public Level getEffectiveLevel() {
        java.util.logging.Level effectiveLevel = this.julLogger.getLevel();
        while (effectiveLevel == null) {
            java.util.logging.Logger parent = this.julLogger.getParent();
            if (parent == null) continue;
            effectiveLevel = parent.getLevel();
        }
        return LoggingUtils.mapFromJUL(effectiveLevel);
    }

    public boolean isEnabledFor(Priority priority) {
        return this.julLogger.isLoggable(LoggingUtils.mapToJULLevel(priority.toInt()));
    }

    public boolean isTraceEnabled() {
        return this.julLogger.isLoggable(java.util.logging.Level.FINEST);
    }

    public void trace(String message) {
        this.julLogger.log(java.util.logging.Level.FINEST, String.valueOf(message));
    }

    public void addHandler(Handler handler) {
        this.julLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.julLogger.removeHandler(handler);
    }

    public void removeAllHandlers() {
        Arrays.stream(this.julLogger.getHandlers()).forEach(this.julLogger::removeHandler);
    }

    public Handler getHandler(String name) {
        return Arrays.stream(this.julLogger.getHandlers()).filter(handler -> handler.getClass().getSimpleName().equals(name)).findFirst().orElse(null);
    }

    public void catching(Throwable ex) {
        String message = ex.getMessage() != null ? ex.getMessage() : "";
        this.log(Level.ERROR, message, ex);
    }

    public Handler[] getHandlers() {
        return this.julLogger.getHandlers();
    }

    public java.util.logging.Logger getJulLogger() {
        return this.julLogger;
    }
}

