/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.impl;

import ch.ethz.sis.shared.log.standard.core.Priority;
import ch.ethz.sis.shared.log.standard.utils.LoggingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractJulLogger {
    private final Logger julLogger;

    protected AbstractJulLogger(String name) {
        this.julLogger = Logger.getLogger(name);
    }

    public String getName() {
        return this.julLogger.getName();
    }

    private void debug(Object message) {
        this.julLogger.log(Level.FINE, String.valueOf(message));
    }

    private void debug(Object message, Throwable t) {
        this.julLogger.log(Level.FINE, String.valueOf(message), t);
    }

    private void info(Object message) {
        this.julLogger.log(Level.INFO, String.valueOf(message));
    }

    private void info(Object message, Throwable t) {
        this.julLogger.log(Level.INFO, String.valueOf(message), t);
    }

    private void warn(Object message) {
        this.julLogger.log(Level.WARNING, String.valueOf(message));
    }

    private void warn(Object message, Throwable t) {
        this.julLogger.log(Level.WARNING, String.valueOf(message), t);
    }

    private void error(Object message) {
        this.julLogger.log(Level.SEVERE, String.valueOf(message));
    }

    private void error(Object message, Throwable t) {
        this.julLogger.log(Level.SEVERE, String.valueOf(message), t);
    }

    private void fatal(Object message) {
        this.julLogger.log(Level.SEVERE, "FATAL: " + String.valueOf(message));
    }

    private void fatal(Object message, Throwable t) {
        this.julLogger.log(Level.SEVERE, "FATAL: " + String.valueOf(message), t);
    }

    public boolean isDebugEnabled() {
        return this.julLogger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julLogger.isLoggable(Level.INFO);
    }

    public boolean isErrorEnabled() {
        return this.julLogger.isLoggable(Level.SEVERE);
    }

    protected void log(Priority priority, Object message, Throwable t) {
        Level julLevel = LoggingUtils.mapToJULLevel(priority.toInt());
        this.julLogger.log(julLevel, String.valueOf(message), t);
    }

    private void log(Priority priority, Object message) {
        this.log(priority, message, null);
    }

    private void setLevel(ch.ethz.sis.shared.log.standard.core.Level level) {
        this.julLogger.setLevel(LoggingUtils.mapToJUL(level));
    }

    private ch.ethz.sis.shared.log.standard.core.Level getLevel() {
        return LoggingUtils.mapFromJUL(this.julLogger.getLevel());
    }

    public ch.ethz.sis.shared.log.standard.core.Level getEffectiveLevel() {
        Level root;
        Logger p = this.julLogger;
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        int hops = 0;
        int MAX_HOPS = 64;
        while (p != null && seen.add(p) && hops++ < MAX_HOPS) {
            Level lvl = p.getLevel();
            if (lvl != null) {
                return LoggingUtils.mapFromJUL(lvl);
            }
            Logger next = p.getParent();
            if (next == p) break;
            p = next;
        }
        return LoggingUtils.mapFromJUL((root = Logger.getLogger("").getLevel()) != null ? root : Level.INFO);
    }

    private boolean isEnabledFor(Priority priority) {
        return this.julLogger.isLoggable(LoggingUtils.mapToJULLevel(priority.toInt()));
    }

    public boolean isTraceEnabled() {
        return this.julLogger.isLoggable(Level.FINEST);
    }

    private void trace(String message) {
        this.julLogger.log(Level.FINEST, String.valueOf(message));
    }

    private void addHandler(Handler handler) {
        this.julLogger.addHandler(handler);
    }

    private void removeHandler(Handler handler) {
        this.julLogger.removeHandler(handler);
    }

    private void removeAllHandlers() {
        Arrays.stream(this.julLogger.getHandlers()).forEach(this.julLogger::removeHandler);
    }

    public Handler getHandler(String name) {
        return Arrays.stream(this.julLogger.getHandlers()).filter(handler -> handler.getClass().getSimpleName().equals(name)).findFirst().orElse(null);
    }

    private void catching(Throwable ex) {
        String message = ex.getMessage() != null ? ex.getMessage() : "";
        this.log(ch.ethz.sis.shared.log.standard.core.Level.ERROR, message, ex);
    }

    public Handler[] getHandlers() {
        return this.julLogger.getHandlers();
    }

    public Logger getJulLogger() {
        return this.julLogger;
    }
}

