/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.impl;

import ch.ethz.sis.shared.log.standard.Logger;
import ch.ethz.sis.shared.log.standard.core.Level;
import ch.ethz.sis.shared.log.standard.impl.AbstractJulLogger;

class StandardLogger
extends AbstractJulLogger
implements Logger {
    private static final String ENTRY_MARKER = "Enter ";
    private static final String EXIT_MARKER = "Exit ";

    public StandardLogger(String name) {
        super(name);
    }

    public static Logger getStandardLogger(String name) {
        return new StandardLogger(name);
    }

    public static Logger getStandardLogger(Class<?> clazz) {
        return StandardLogger.getStandardLogger(clazz.getName());
    }

    @Override
    public void traceAccess(String message, Object ... args) {
        if (this.getEffectiveLevel() == Level.TRACE) {
            this.traceAccess(message, null, args);
        }
    }

    @Override
    public void traceAccess(String message, Throwable ex, Object ... args) {
        if (this.getEffectiveLevel() == Level.TRACE) {
            this.log(Level.TRACE, this.format(ENTRY_MARKER, message, args), ex);
        }
    }

    @Override
    public <R> R traceExit(R result) {
        if (this.getEffectiveLevel() == Level.TRACE) {
            this.log(Level.TRACE, this.exitMsg(result), null);
        }
        return result;
    }

    @Override
    public void catching(Throwable ex) {
        String message = ex.getMessage() != null ? ex.getMessage() : "";
        this.log(Level.ERROR, message, ex);
    }

    @Override
    public <T extends Throwable> T throwing(T ex) {
        this.log(Level.ERROR, ex.getMessage(), ex);
        return ex;
    }

    public void debug(String message, Object ... args) {
        if (this.getEffectiveLevel() == Level.DEBUG || this.getEffectiveLevel() == Level.TRACE) {
            this.log(Level.DEBUG, this.format(message, args), null);
        }
    }

    @Override
    public void info(String message, Object ... args) {
        this.info(message, null, args);
    }

    @Override
    public void info(String message, Throwable ex, Object ... args) {
        this.log(Level.INFO, this.format(message, args), null);
    }

    public void warn(String message, Object ... args) {
        if (this.getEffectiveLevel() == Level.WARN || this.getEffectiveLevel() == Level.INFO || this.getEffectiveLevel() == Level.DEBUG || this.getEffectiveLevel() == Level.TRACE) {
            this.log(Level.WARN, this.format(message, args), null);
        }
    }

    private String exitMsg(Object result) {
        return "EXIT Returning " + String.valueOf(result);
    }

    private String format(String message, Object ... args) {
        return this.format(null, message, args);
    }

    private String format(String markers, String message, Object ... args) {
        Object finalMessage;
        int count = args == null ? 0 : args.length;
        Object object = finalMessage = markers != null ? markers : "";
        if (count == 0) {
            finalMessage = (String)finalMessage + message;
        } else if (message != null) {
            finalMessage = (String)finalMessage + String.format(message, args);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("params(");
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Object arg = args[i];
                sb.append(String.valueOf(arg));
            }
            sb.append(")");
            finalMessage = (String)finalMessage + sb.toString();
        }
        return finalMessage;
    }
}

