/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonIgnoreType
public class FetchOptionsToStringBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private FetchOptions<?> mainFetchOptions;
    private HashMap<String, FetchOptions<?>> childrenFetchOptions;
    private List<String> keys;

    public FetchOptionsToStringBuilder(String name, FetchOptions<?> fetchOptions) {
        this.name = name;
        this.mainFetchOptions = fetchOptions;
        this.childrenFetchOptions = new HashMap();
        this.keys = new ArrayList<String>();
    }

    public FetchOptionsToStringBuilder addFetchOption(String key, FetchOptions<?> fo) {
        this.childrenFetchOptions.put(key, fo);
        this.keys.add(key);
        return this;
    }

    public String toString(String anIndentation, Set<FetchOptions<?>> processed) {
        StringBuilder sb = new StringBuilder();
        String indentation = anIndentation;
        if (indentation.isEmpty()) {
            if (this.mainFetchOptions.getSortBy() != null) {
                sb.append(this.name + " " + this.mainFetchOptions.getSortBy() + "\n");
            } else {
                sb.append(this.name + "\n");
            }
        }
        processed.add(this.mainFetchOptions);
        indentation = indentation + "    ";
        for (String key : this.keys) {
            FetchOptions<?> subOptions = this.childrenFetchOptions.get(key);
            if (subOptions == null) continue;
            String sortOptionsPart = "";
            if (subOptions.getSortBy() != null) {
                sortOptionsPart = " " + subOptions.getSortBy();
            }
            FetchOptionsToStringBuilder sbb = subOptions.getFetchOptionsStringBuilder();
            if (processed.contains(subOptions)) {
                sb.append(indentation + "with " + key + sortOptionsPart + "(recursive)\n");
                continue;
            }
            sb.append(indentation + "with " + key + sortOptionsPart + "\n");
            sb.append(sbb.toString(indentation, processed));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("", new HashSet());
    }
}

