/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.classic.impl;

import ch.ethz.sis.shared.log.standard.core.Priority;
import ch.ethz.sis.shared.log.standard.utils.LoggingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger {
    private final java.util.logging.Logger julLogger;

    protected Logger(String name) {
        this.julLogger = java.util.logging.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public String getName() {
        return this.julLogger.getName();
    }

    public void debug(Object message) {
        this.julLogger.log(Level.FINE, String.valueOf(message));
    }

    public void debug(Object message, Throwable t) {
        this.julLogger.log(Level.FINE, String.valueOf(message), t);
    }

    public void info(Object message) {
        this.julLogger.log(Level.INFO, String.valueOf(message));
    }

    public void info(Object message, Throwable t) {
        this.julLogger.log(Level.INFO, String.valueOf(message), t);
    }

    public void warn(Object message) {
        this.julLogger.log(Level.WARNING, String.valueOf(message));
    }

    public void warn(Object message, Throwable t) {
        this.julLogger.log(Level.WARNING, String.valueOf(message), t);
    }

    public void error(Object message) {
        this.julLogger.log(Level.SEVERE, String.valueOf(message));
    }

    public void error(Object message, Throwable t) {
        this.julLogger.log(Level.SEVERE, String.valueOf(message), t);
    }

    public void fatal(Object message) {
        this.julLogger.log(Level.SEVERE, "FATAL: " + String.valueOf(message));
    }

    public void fatal(Object message, Throwable t) {
        this.julLogger.log(Level.SEVERE, "FATAL: " + String.valueOf(message), t);
    }

    public boolean isDebugEnabled() {
        return this.julLogger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.julLogger.isLoggable(Level.INFO);
    }

    public boolean isErrorEnabled() {
        return this.julLogger.isLoggable(Level.SEVERE);
    }

    public void log(Priority priority, Object message, Throwable t) {
        Level julLevel = LoggingUtils.mapToJULLevel(priority.toInt());
        this.julLogger.log(julLevel, String.valueOf(message), t);
    }

    public void log(Priority priority, Object message) {
        this.log(priority, message, null);
    }

    public void setLevel(ch.ethz.sis.shared.log.standard.core.Level level) {
        this.julLogger.setLevel(LoggingUtils.mapToJUL(level));
    }

    public ch.ethz.sis.shared.log.standard.core.Level getLevel() {
        return LoggingUtils.mapFromJUL(this.julLogger.getLevel());
    }

    public ch.ethz.sis.shared.log.standard.core.Level getEffectiveLevel() {
        Level root;
        java.util.logging.Logger p = this.julLogger;
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        int hops = 0;
        int MAX_HOPS = 64;
        while (p != null && seen.add(p) && hops++ < MAX_HOPS) {
            Level lvl = p.getLevel();
            if (lvl != null) {
                return LoggingUtils.mapFromJUL(lvl);
            }
            java.util.logging.Logger next = p.getParent();
            if (next == p) break;
            p = next;
        }
        return LoggingUtils.mapFromJUL((root = java.util.logging.Logger.getLogger("").getLevel()) != null ? root : Level.INFO);
    }

    public boolean isEnabledFor(Priority priority) {
        return this.julLogger.isLoggable(LoggingUtils.mapToJULLevel(priority.toInt()));
    }

    public boolean isTraceEnabled() {
        return this.julLogger.isLoggable(Level.FINEST);
    }

    public void trace(String message) {
        this.julLogger.log(Level.FINEST, String.valueOf(message));
    }

    public void addHandler(Handler handler) {
        this.julLogger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.julLogger.removeHandler(handler);
    }

    public void removeAllHandlers() {
        Arrays.stream(this.julLogger.getHandlers()).forEach(this.julLogger::removeHandler);
    }

    public Handler getHandler(String name) {
        return Arrays.stream(this.julLogger.getHandlers()).filter(handler -> handler.getClass().getSimpleName().equals(name)).findFirst().orElse(null);
    }

    public void catching(Throwable ex) {
        String message = ex.getMessage() != null ? ex.getMessage() : "";
        this.log(ch.ethz.sis.shared.log.standard.core.Level.ERROR, message, ex);
    }

    public Handler[] getHandlers() {
        return this.julLogger.getHandlers();
    }

    public java.util.logging.Logger getJulLogger() {
        return this.julLogger;
    }
}

