/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.handlers;

import ch.ethz.sis.shared.log.classic.event.BundledTimestampTriggeringEventEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class BundledBufferingHandler
extends Handler {
    private final BundledTimestampTriggeringEventEvaluator evaluator = new BundledTimestampTriggeringEventEvaluator();
    private final List<LogRecord> buffer = new ArrayList<LogRecord>();

    public BundledBufferingHandler() {
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public synchronized void publish(LogRecord record) {
        this.buffer.add(record);
        if (this.evaluator.isTriggeringEvent(record)) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        Formatter formatter = this.getFormatter();
        for (LogRecord record : this.buffer) {
            System.out.print(formatter.format(record));
        }
        this.buffer.clear();
    }

    @Override
    public void flush() {
        this.flushBuffer();
    }

    @Override
    public void close() throws SecurityException {
        this.flushBuffer();
    }
}

