/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.services.store;

import ch.ethz.sis.microservices.download.server.logging.LogManager;
import ch.ethz.sis.microservices.download.server.logging.Logger;
import ch.ethz.sis.microservices.download.server.services.Service;
import ch.ethz.sis.microservices.download.server.services.store.FileInfoHandler;
import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ContentCopy;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.IDataStoreServerApi;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.DataSetFile;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fetchoptions.DataSetFileFetchOptions;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.search.DataSetFileSearchCriteria;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractFileServiceHandler
extends Service {
    private static Logger logger = LogManager.getLogger(FileInfoHandler.class);

    protected void doAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String openbisURL = (String)this.getServiceConfig().getParameters().get("openbis-url");
        String datastoreURL = (String)this.getServiceConfig().getParameters().get("datastore-url");
        int servicesTimeout = Integer.parseInt((String)this.getServiceConfig().getParameters().get("services-timeout"));
        String allowedExternalDMSCode = (String)this.getServiceConfig().getParameters().get("allowedExternalDMSCode");
        String allowedContentCopyPath = (String)this.getServiceConfig().getParameters().get("allowedContentCopyPath");
        String sessionToken = request.getParameter("sessionToken");
        String datasetPermId = request.getParameter("datasetPermId");
        String externalDMSCode = request.getParameter("externalDMSCode");
        String contentCopyPath = request.getParameter("contentCopyPath");
        String datasetPathToFile = request.getParameter("datasetPathToFile");
        if (!externalDMSCode.equals(allowedExternalDMSCode)) {
            throw new RuntimeException("The requested externalDMSCode is not available.");
        }
        boolean userCanAccessDatasetFile = this.userCanAccessDatasetFile(openbisURL, datastoreURL, servicesTimeout, sessionToken, datasetPermId, externalDMSCode, contentCopyPath, datasetPathToFile);
        boolean isFileAccessible = false;
        if (userCanAccessDatasetFile) {
            isFileAccessible = this.isDatasetFileAccessible(allowedContentCopyPath, datasetPermId, contentCopyPath, datasetPathToFile);
        }
        Path pathToFile = this.getPathToFile(contentCopyPath, datasetPathToFile);
        if (isFileAccessible) {
            this.success(pathToFile, request, response);
        } else {
            this.failure(pathToFile, request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doAction(request, response);
    }

    protected abstract void success(Path var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException;

    protected abstract void failure(Path var1, HttpServletRequest var2, HttpServletResponse var3) throws ServletException, IOException;

    private DataSet getDataset(String openbisURL, int openbisTimeout, String sessionToken, String datasetPermId, String externalDMSCode, String contentCopyPath) {
        IApplicationServerApi v3 = (IApplicationServerApi)HttpInvokerUtils.createServiceStub(IApplicationServerApi.class, (String)openbisURL, (long)openbisTimeout);
        DataSetFetchOptions dataSetFetchOptions = new DataSetFetchOptions();
        dataSetFetchOptions.withLinkedData().withExternalDms();
        DataSetPermId id = new DataSetPermId(datasetPermId);
        Map datasets = v3.getDataSets(sessionToken, Arrays.asList(id), dataSetFetchOptions);
        DataSet dataset = (DataSet)datasets.get(id);
        if (dataset != null && !dataset.getLinkedData().getContentCopies().isEmpty()) {
            for (ContentCopy contentCopy : dataset.getLinkedData().getContentCopies()) {
                if (!contentCopy.getExternalDms().getCode().equals(externalDMSCode) || !contentCopy.getPath().equals(contentCopyPath)) continue;
                return dataset;
            }
        }
        return null;
    }

    private DataSetFile getDatasetFile(String datastoreURL, int datastoreTimeout, String sessionToken, String datasetPermId, String datasetPathToFile) {
        IDataStoreServerApi v3Dss = (IDataStoreServerApi)HttpInvokerUtils.createServiceStub(IDataStoreServerApi.class, (String)datastoreURL, (long)datastoreTimeout);
        DataSetFileSearchCriteria searchCriteria = new DataSetFileSearchCriteria();
        searchCriteria.withDataSet().withCode().thatEquals(datasetPermId);
        DataSetFileFetchOptions fetchOptions = new DataSetFileFetchOptions();
        SearchResult files = v3Dss.searchFiles(sessionToken, searchCriteria, fetchOptions);
        for (DataSetFile file : files.getObjects()) {
            if (!file.getPath().equals(datasetPathToFile)) continue;
            return file;
        }
        return null;
    }

    private boolean userCanAccessDatasetFile(String openbisURL, String datastoreURL, int servicesTimeout, String sessionToken, String datasetPermId, String externalDMSCode, String contentCopyPath, String datasetPathToFile) {
        DataSet dataSet = this.getDataset(openbisURL, servicesTimeout, sessionToken, datasetPermId, externalDMSCode, contentCopyPath);
        DataSetFile file = this.getDatasetFile(datastoreURL, servicesTimeout, sessionToken, datasetPermId, datasetPathToFile);
        return dataSet != null && file != null;
    }

    private Path getPathToFile(String contentCopyPath, String datasetPathToFile) {
        return Paths.get(contentCopyPath, datasetPathToFile);
    }

    private boolean isDatasetFileAccessible(String allowedContentCopyPath, String datasetPermId, String contentCopyPath, String datasetPathToFile) {
        boolean isFileAccessible = false;
        Path pathToFile = this.getPathToFile(contentCopyPath, datasetPathToFile);
        String normalizedPathToFile = pathToFile.normalize().toString();
        if (!normalizedPathToFile.startsWith(allowedContentCopyPath)) {
            throw new RuntimeException("Given datasetPathToFile goes outside allowedContentCopyPath");
        }
        try {
            isFileAccessible = Files.exists(pathToFile, new LinkOption[0]);
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
        }
        return isFileAccessible;
    }
}

