/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadClientConfig;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadInputStreamReader;
import ch.ethz.sis.filetransfer.DownloadPreferences;
import ch.ethz.sis.filetransfer.DownloadRange;
import ch.ethz.sis.filetransfer.DownloadSession;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.DownloadStatus;
import ch.ethz.sis.filetransfer.DownloadStreamId;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadListener;
import ch.ethz.sis.filetransfer.IRetryAction;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.time.StopWatch;

public class DownloadClientDownload {
    private DownloadClientConfig config;
    private DownloadPreferences preferences = new DownloadPreferences();
    private IUserSessionId userSessionId;
    private DownloadSession downloadSession;
    private Set<IDownloadItemId> itemIdsToDownload = new LinkedHashSet<IDownloadItemId>();
    private Set<IDownloadItemId> itemIdsDownloaded = new LinkedHashSet<IDownloadItemId>();
    private Map<IDownloadItemId, Set<Integer>> chunksToDownload = new HashMap<IDownloadItemId, Set<Integer>>();
    private Map<IDownloadItemId, Set<Integer>> chunksDownloaded = new HashMap<IDownloadItemId, Set<Integer>>();
    private List<DownloadThread> downloadThreads = new LinkedList<DownloadThread>();
    private List<IDownloadListener> listeners = new ArrayList<IDownloadListener>();
    private LinkedBlockingQueue<IListenerExecution> listenersQueue = new LinkedBlockingQueue();
    private ListenersThread listenersThread;
    private DownloadStatus status = DownloadStatus.NEW;

    DownloadClientDownload(DownloadClientConfig config, IUserSessionId userSessionId) {
        this.config = config;
        this.userSessionId = userSessionId;
    }

    public IUserSessionId getUserSession() {
        return this.userSessionId;
    }

    public DownloadSessionId getDownloadSessionId() {
        if (this.status.equals((Object)DownloadStatus.NEW)) {
            throw new IllegalStateException("Download session id cannot be read before a download is started.");
        }
        return this.downloadSession != null ? this.downloadSession.getDownloadSessionId() : null;
    }

    public void addItem(IDownloadItemId itemId) {
        this.addItems(Collections.singleton(itemId));
    }

    public void addItems(Collection<IDownloadItemId> itemIds) {
        if (itemIds == null) {
            throw new IllegalArgumentException("Item ids cannot be null");
        }
        if (!this.status.equals((Object)DownloadStatus.NEW)) {
            throw new IllegalStateException("Item ids cannot be added once a download is started.");
        }
        for (IDownloadItemId itemId : itemIds) {
            if (itemId == null) {
                throw new IllegalArgumentException("Item id cannot be null");
            }
            this.itemIdsToDownload.add(itemId);
        }
    }

    public List<IDownloadItemId> getItems() {
        return Collections.unmodifiableList(new ArrayList<IDownloadItemId>(this.itemIdsToDownload));
    }

    public void addListener(IDownloadListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners.add(listener);
    }

    public void setPreferences(DownloadPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences cannot be null");
        }
        if (!this.status.equals((Object)DownloadStatus.NEW)) {
            throw new IllegalStateException("Preferences cannot be set once a download is started.");
        }
        this.preferences = preferences;
    }

    public DownloadPreferences gePreferences() {
        return this.preferences;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    private synchronized void setStatus(DownloadStatus newStatus, Collection<Exception> exceptions) {
        if (newStatus.equals((Object)DownloadStatus.STARTED)) {
            if (this.status.equals((Object)DownloadStatus.NEW)) {
                this.status = DownloadStatus.STARTED;
                this.notifyDownloadStarted();
                if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
                    this.config.getLogger().log(this.getClass(), LogLevel.INFO, "Download state changed to: " + (Object)((Object)this.status));
                }
            }
        } else if (newStatus.equals((Object)DownloadStatus.FINISHED)) {
            if (this.status.equals((Object)DownloadStatus.STARTED)) {
                this.status = DownloadStatus.FINISHED;
                this.finishDownloadSession();
                this.notifyDownloadFinished();
                this.finishDownloadThreads();
                this.finishListenersThread();
                if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
                    this.config.getLogger().log(this.getClass(), LogLevel.INFO, "Download state changed to: " + (Object)((Object)this.status));
                }
            }
        } else if (newStatus.equals((Object)DownloadStatus.FAILED) && (this.status.equals((Object)DownloadStatus.NEW) || this.status.equals((Object)DownloadStatus.STARTED))) {
            this.status = DownloadStatus.FAILED;
            this.finishDownloadSession();
            this.notifyDownloadFailed(exceptions);
            this.finishDownloadThreads();
            this.finishListenersThread();
            if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
                this.config.getLogger().log(this.getClass(), LogLevel.INFO, "Download state changed to: " + (Object)((Object)this.status));
            }
        }
    }

    private synchronized void refreshStatus() {
        HashSet<DownloadStatus> threadStatuses = new HashSet<DownloadStatus>();
        LinkedList<Exception> threadExceptions = new LinkedList<Exception>();
        for (DownloadThread downloadThread : this.downloadThreads) {
            threadStatuses.add(downloadThread.getStatus());
            threadExceptions.add(downloadThread.getException());
        }
        if (threadStatuses.contains((Object)DownloadStatus.STARTED)) {
            this.setStatus(DownloadStatus.STARTED, null);
        }
        if (threadStatuses.contains((Object)DownloadStatus.FINISHED) && !threadStatuses.contains((Object)DownloadStatus.NEW) && !threadStatuses.contains((Object)DownloadStatus.STARTED)) {
            this.setStatus(DownloadStatus.FINISHED, null);
        }
        if (threadStatuses.equals(Collections.singleton(DownloadStatus.FAILED))) {
            this.setStatus(DownloadStatus.FAILED, threadExceptions);
        }
    }

    public void start() throws DownloadException {
        if (!this.status.equals((Object)DownloadStatus.NEW)) {
            throw new IllegalStateException("Download has been already started.");
        }
        this.setStatus(DownloadStatus.STARTED, null);
        try {
            this.startDownloadSession();
            this.startListenersThread();
            this.startDownloadThreads();
        }
        catch (Exception e) {
            if (this.config.getLogger().isEnabled(LogLevel.ERROR)) {
                this.config.getLogger().log(this.getClass(), LogLevel.ERROR, "Couldn't start download", e);
            }
            this.setStatus(DownloadStatus.FAILED, Collections.singleton(e));
            throw new DownloadException("Couldn't start a download", e, false);
        }
    }

    public void await() {
        try {
            this.await(null);
        }
        catch (TimeoutException timeoutException) {}
    }

    public void await(int timeoutInMillis) throws TimeoutException {
        this.await((Integer)timeoutInMillis);
    }

    private void await(Integer timeoutInMillisOrNull) throws TimeoutException {
        if (this.status.equals((Object)DownloadStatus.NEW)) {
            throw new IllegalStateException("Download has to be started before waiting for the results");
        }
        if (timeoutInMillisOrNull != null && timeoutInMillisOrNull <= 0) {
            throw new IllegalArgumentException("Timeout should be > 0");
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.addAll(this.downloadThreads);
        if (this.listenersThread != null) {
            threads.add(this.listenersThread);
        }
        Long timeoutTimeOrNull = timeoutInMillisOrNull != null ? Long.valueOf(System.currentTimeMillis() + (long)timeoutInMillisOrNull.intValue()) : null;
        try {
            for (Thread thread : threads) {
                if (timeoutTimeOrNull != null) {
                    long millisLeft = timeoutTimeOrNull - System.currentTimeMillis();
                    if (millisLeft > 0L) {
                        thread.join(millisLeft);
                        continue;
                    }
                    throw new TimeoutException();
                }
                thread.join();
            }
        }
        catch (InterruptedException e) {
            if (this.config.getLogger().isEnabled(LogLevel.WARN)) {
                this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Got interrupted while waiting for the results", e);
            }
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public Map<IDownloadItemId, Path> getResults() throws DownloadException {
        if (!this.status.equals((Object)DownloadStatus.FINISHED)) {
            throw new IllegalStateException("Results are available only for downloads that have successfully finished (current download status: " + (Object)((Object)this.status) + ")");
        }
        HashMap<IDownloadItemId, Path> itemPaths = new HashMap<IDownloadItemId, Path>();
        for (final IDownloadItemId itemId : this.itemIdsDownloaded) {
            Path itemPath = this.config.getRetryProvider().executeWithRetry(new IRetryAction<Path>(){

                @Override
                public Path execute() throws DownloadException {
                    return DownloadClientDownload.this.config.getStore().getItemPath(DownloadClientDownload.this.userSessionId, DownloadClientDownload.this.downloadSession.getDownloadSessionId(), itemId);
                }
            });
            itemPaths.put(itemId, itemPath);
        }
        return itemPaths;
    }

    private void startListenersThread() {
        this.listenersThread = new ListenersThread();
        this.listenersThread.start();
    }

    private void startDownloadSession() throws DownloadException {
        if (this.itemIdsToDownload == null || this.itemIdsToDownload.isEmpty()) {
            throw new DownloadException("Item ids cannot be null or empty", false);
        }
        if (this.preferences == null) {
            throw new DownloadException("Preferences cannot be null", false);
        }
        this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

            @Override
            public Void execute() throws DownloadException {
                DownloadClientDownload.this.downloadSession = DownloadClientDownload.this.config.getServer().startDownloadSession(DownloadClientDownload.this.userSessionId, new ArrayList<IDownloadItemId>(DownloadClientDownload.this.itemIdsToDownload), DownloadClientDownload.this.preferences);
                return null;
            }
        });
        this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

            @Override
            public Void execute() throws DownloadException {
                DownloadClientDownload.this.config.getServer().queue(DownloadClientDownload.this.downloadSession.getDownloadSessionId(), new ArrayList<DownloadRange>(DownloadClientDownload.this.downloadSession.getRanges().values()));
                return null;
            }
        });
        if (this.downloadSession.getRanges() != null) {
            for (Map.Entry<IDownloadItemId, DownloadRange> entry : this.downloadSession.getRanges().entrySet()) {
                IDownloadItemId itemId = entry.getKey();
                DownloadRange itemRange = entry.getValue();
                LinkedHashSet<Integer> itemChunksToDownload = new LinkedHashSet<Integer>();
                int i = itemRange.getStart();
                while (i <= itemRange.getEnd()) {
                    itemChunksToDownload.add(i);
                    ++i;
                }
                this.chunksToDownload.put(itemId, itemChunksToDownload);
            }
            if (this.config.getLogger().isEnabled(LogLevel.DEBUG)) {
                this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Item ids to download: " + this.itemIdsToDownload);
                this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Chunks to download: " + this.chunksToDownload);
            }
        }
    }

    private void startDownloadThreads() {
        int threadIndex = 0;
        while (threadIndex < this.downloadSession.getStreamIds().size()) {
            DownloadStreamId streamId = this.downloadSession.getStreamIds().get(threadIndex);
            DownloadThread thread = new DownloadThread(threadIndex, streamId);
            this.downloadThreads.add(thread);
            ++threadIndex;
        }
        for (DownloadThread downloadThread : this.downloadThreads) {
            downloadThread.start();
        }
    }

    private void finishDownloadSession() {
        block3: {
            if (this.downloadSession == null) {
                return;
            }
            try {
                this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

                    @Override
                    public Void execute() throws DownloadException {
                        DownloadClientDownload.this.config.getServer().finishDownloadSession(DownloadClientDownload.this.downloadSession.getDownloadSessionId());
                        return null;
                    }
                });
            }
            catch (DownloadException e) {
                if (!this.config.getLogger().isEnabled(LogLevel.WARN)) break block3;
                this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't finish a download session: " + this.downloadSession.getDownloadSessionId(), e);
            }
        }
    }

    private void finishListenersThread() {
        if (this.listenersThread != null) {
            this.listenersThread.addFinishMarker();
        }
    }

    private void finishDownloadThreads() {
        for (DownloadThread thread : this.downloadThreads) {
            try {
                thread.interrupt();
            }
            catch (Exception e) {
                if (!this.config.getLogger().isEnabled(LogLevel.WARN)) continue;
                this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't interrupt a download thread", e);
            }
        }
    }

    private void notifyDownloadStarted() {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Download started";
            }

            @Override
            public void execute() {
                for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                    listener.onDownloadStarted();
                }
            }
        });
    }

    private void notifyDownloadFinished() {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Download finished";
            }

            @Override
            public void execute() {
                block3: {
                    try {
                        Map<IDownloadItemId, Path> itemPaths = DownloadClientDownload.this.getResults();
                        for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                            listener.onDownloadFinished(itemPaths);
                        }
                    }
                    catch (DownloadException e) {
                        if (!DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.WARN)) break block3;
                        DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't notify listeners about a finished download", e);
                    }
                }
            }
        });
    }

    private void notifyDownloadFailed(final Collection<Exception> e) {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Download failed";
            }

            @Override
            public void execute() {
                for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                    listener.onDownloadFailed(e);
                }
            }
        });
    }

    private void notifyItemStarted(final IDownloadItemId itemId) {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Item started " + itemId;
            }

            @Override
            public void execute() {
                for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                    listener.onItemStarted(itemId);
                }
            }
        });
    }

    private void notifyChunkDownloaded(final int sequenceNumber) {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Chunk " + sequenceNumber + " downloaded";
            }

            @Override
            public void execute() {
                for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                    listener.onChunkDownloaded(sequenceNumber);
                }
            }
        });
    }

    private void notifyItemFinished(final IDownloadItemId itemId) {
        this.notify(new IListenerExecution(){

            @Override
            public String getDescription() {
                return "Item finished " + itemId;
            }

            @Override
            public void execute() {
                block3: {
                    try {
                        Path itemPath = DownloadClientDownload.this.config.getRetryProvider().executeWithRetry(new IRetryAction<Path>(){

                            @Override
                            public Path execute() throws DownloadException {
                                return DownloadClientDownload.this.config.getStore().getItemPath(DownloadClientDownload.this.userSessionId, DownloadClientDownload.this.downloadSession.getDownloadSessionId(), itemId);
                            }
                        });
                        for (IDownloadListener listener : DownloadClientDownload.this.listeners) {
                            listener.onItemFinished(itemId, itemPath);
                        }
                    }
                    catch (DownloadException e) {
                        if (!DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.WARN)) break block3;
                        DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't notify listeners about finished item " + itemId, e);
                    }
                }
            }
        });
    }

    private void notify(IListenerExecution listenerExecution) {
        block4: {
            if (this.listenersThread != null) {
                this.listenersQueue.add(listenerExecution);
            } else {
                try {
                    listenerExecution.execute();
                }
                catch (Exception e) {
                    if (!this.config.getLogger().isEnabled(LogLevel.WARN)) break block4;
                    this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Listener has thrown an exception", e);
                }
            }
        }
    }

    private class DownloadThread
    extends Thread {
        private DownloadStreamId streamId;
        private DownloadStatus status;
        private Exception exception;

        public DownloadThread(int threadIndex, DownloadStreamId streamId) {
            super("download-" + DownloadClientDownload.this.downloadSession.getDownloadSessionId().getId() + "-" + (threadIndex + 1));
            this.status = DownloadStatus.STARTED;
            this.setDaemon(true);
            this.streamId = streamId;
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted() && !DownloadClientDownload.this.itemIdsToDownload.equals(DownloadClientDownload.this.itemIdsDownloaded)) {
                    DownloadClientDownload.this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

                        @Override
                        public Void execute() throws DownloadException {
                            DownloadInputStreamReader reader = null;
                            try {
                                reader = DownloadThread.this.getChunkReader();
                                Chunk chunk = null;
                                while ((chunk = DownloadThread.this.readChunk(reader)) != null) {
                                    DownloadThread.this.storeChunk(chunk);
                                }
                                if (DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.DEBUG)) {
                                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Input stream finished");
                                }
                            }
                            finally {
                                if (reader != null) {
                                    DownloadThread.this.closeChunkReader(reader);
                                }
                            }
                            DownloadThread.this.requeueChunks();
                            return null;
                        }
                    });
                }
                this.setStatus(DownloadStatus.FINISHED);
            }
            catch (Exception e) {
                if (DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.ERROR)) {
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.ERROR, "Download thread failed", e);
                }
                this.setException(e);
                this.setStatus(DownloadStatus.FAILED);
            }
        }

        private DownloadStatus getStatus() {
            return this.status;
        }

        private void setStatus(DownloadStatus status) {
            this.status = status;
            DownloadClientDownload.this.refreshStatus();
        }

        private void setException(Exception exception) {
            this.exception = exception;
        }

        private Exception getException() {
            return this.exception;
        }

        private DownloadInputStreamReader getChunkReader() throws DownloadException {
            return DownloadClientDownload.this.config.getRetryProvider().executeWithRetry(new IRetryAction<DownloadInputStreamReader>(){

                @Override
                public DownloadInputStreamReader execute() throws DownloadException {
                    InputStream stream = DownloadClientDownload.this.config.getServer().download(DownloadClientDownload.this.downloadSession.getDownloadSessionId(), DownloadThread.this.streamId, null);
                    return new DownloadInputStreamReader(DownloadClientDownload.this.config.getLogger(), stream, DownloadClientDownload.this.config.getDeserializerProvider().createChunkDeserializer());
                }
            });
        }

        private Chunk readChunk(DownloadInputStreamReader reader) throws DownloadException {
            try {
                return reader.read();
            }
            catch (Exception e) {
                throw new DownloadException("Couldn't read a chunk: " + e.getMessage(), e, true);
            }
        }

        private void closeChunkReader(DownloadInputStreamReader reader) {
            block2: {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.WARN)) break block2;
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't close a download stream reader", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeChunk(final Chunk chunk) throws DownloadException {
            DownloadClientDownload.this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

                @Override
                public Void execute() throws DownloadException {
                    DownloadClientDownload.this.config.getStore().storeChunk(DownloadClientDownload.this.userSessionId, DownloadClientDownload.this.downloadSession.getDownloadSessionId(), chunk);
                    return null;
                }
            });
            DownloadClientDownload downloadClientDownload = DownloadClientDownload.this;
            synchronized (downloadClientDownload) {
                if (!DownloadClientDownload.this.itemIdsDownloaded.contains(chunk.getDownloadItemId())) {
                    Set itemChunksToDownload = (Set)DownloadClientDownload.this.chunksToDownload.get(chunk.getDownloadItemId());
                    LinkedHashSet<Integer> itemChunksDownloaded = (LinkedHashSet<Integer>)DownloadClientDownload.this.chunksDownloaded.get(chunk.getDownloadItemId());
                    if (itemChunksDownloaded == null) {
                        itemChunksDownloaded = new LinkedHashSet<Integer>();
                        DownloadClientDownload.this.chunksDownloaded.put(chunk.getDownloadItemId(), itemChunksDownloaded);
                        DownloadClientDownload.this.notifyItemStarted(chunk.getDownloadItemId());
                    }
                    itemChunksToDownload.remove(chunk.getSequenceNumber());
                    itemChunksDownloaded.add(chunk.getSequenceNumber());
                    DownloadClientDownload.this.notifyChunkDownloaded(chunk.getSequenceNumber());
                    if (itemChunksToDownload.isEmpty()) {
                        DownloadClientDownload.this.itemIdsDownloaded.add(chunk.getDownloadItemId());
                        DownloadClientDownload.this.chunksToDownload.remove(chunk.getDownloadItemId());
                        DownloadClientDownload.this.notifyItemFinished(chunk.getDownloadItemId());
                    }
                }
                if (DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.DEBUG)) {
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Item ids to download: " + DownloadClientDownload.this.itemIdsToDownload);
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Item ids downloaded: " + DownloadClientDownload.this.itemIdsDownloaded);
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Chunks to download: " + DownloadClientDownload.this.chunksToDownload);
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Chunks downloaded: " + DownloadClientDownload.this.chunksDownloaded);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requeueChunks() throws DownloadException {
            final LinkedList<DownloadRange> ranges = new LinkedList<DownloadRange>();
            DownloadClientDownload downloadClientDownload = DownloadClientDownload.this;
            synchronized (downloadClientDownload) {
                for (Set itemChunksToDownload : DownloadClientDownload.this.chunksToDownload.values()) {
                    Integer start;
                    if (itemChunksToDownload.isEmpty()) continue;
                    Iterator iterator = itemChunksToDownload.iterator();
                    Integer end = start = (Integer)iterator.next();
                    while (iterator.hasNext()) {
                        Integer current = (Integer)iterator.next();
                        if (current == end + 1) {
                            end = current;
                            continue;
                        }
                        ranges.add(new DownloadRange(start, end));
                        start = current;
                        end = current;
                    }
                    ranges.add(new DownloadRange(start, end));
                }
            }
            if (!ranges.isEmpty()) {
                DownloadClientDownload.this.config.getRetryProvider().executeWithRetry(new IRetryAction<Void>(){

                    @Override
                    public Void execute() throws DownloadException {
                        DownloadClientDownload.this.config.getServer().queue(DownloadClientDownload.this.downloadSession.getDownloadSessionId(), ranges);
                        return null;
                    }
                });
            }
        }
    }

    private static interface IListenerExecution {
        public String getDescription();

        public void execute();
    }

    private class ListenersThread
    extends Thread {
        public ListenersThread() {
            super("download-listeners-" + DownloadClientDownload.this.downloadSession.getDownloadSessionId());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            IListenerExecution listener = null;
            while (!this.isFinishMarker(listener)) {
                try {
                    listener = (IListenerExecution)DownloadClientDownload.this.listenersQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (listener == null) continue;
                    StopWatch watch = new StopWatch();
                    watch.start();
                    listener.execute();
                    watch.stop();
                    if (!DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.DEBUG)) continue;
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Took " + watch + " to execute listener '" + listener.getDescription() + "'");
                }
                catch (Exception e) {
                    if (!DownloadClientDownload.this.config.getLogger().isEnabled(LogLevel.WARN)) continue;
                    DownloadClientDownload.this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Listener has thrown an exception", e);
                }
            }
        }

        private void addFinishMarker() {
            DownloadClientDownload.this.listenersQueue.add(new FinishMarker());
        }

        private boolean isFinishMarker(IListenerExecution listener) {
            return listener instanceof FinishMarker;
        }

        private class FinishMarker
        implements IListenerExecution {
            private FinishMarker() {
            }

            @Override
            public String getDescription() {
                return "Finish marker";
            }

            @Override
            public void execute() {
            }
        }
    }
}

