/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadInputStream;
import ch.ethz.sis.filetransfer.DownloadRange;
import ch.ethz.sis.filetransfer.DownloadServerConfig;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.DownloadState;
import ch.ethz.sis.filetransfer.DownloadStreamId;
import ch.ethz.sis.filetransfer.IChunkProvider;
import ch.ethz.sis.filetransfer.IChunkQueue;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.InvalidDownloadStreamException;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

class DownloadServerDownload {
    private DownloadServerConfig config;
    private IUserSessionId userSessionId;
    private DownloadSessionId downloadSessionId = new DownloadSessionId();
    private List<IDownloadItemId> itemIds;
    private Map<IDownloadItemId, DownloadRange> ranges;
    private Map<IDownloadItemId, List<Chunk>> chunksByItemId;
    private Map<Integer, Chunk> chunksBySequenceNumber;
    private ChunkQueue queue;
    private Integer wishedNumberOfStreams;
    private int allowedNumberOfStreams;
    private Map<DownloadStreamId, DownloadInputStream> streams = new HashMap<DownloadStreamId, DownloadInputStream>();

    public DownloadServerDownload(DownloadServerConfig config, IUserSessionId userSessionId, List<IDownloadItemId> itemIds, Integer wishedNumberOfStreamsOrNull, int allowedNumberOfStreams) throws DownloadException {
        this.config = config;
        this.userSessionId = userSessionId;
        this.itemIds = itemIds;
        this.wishedNumberOfStreams = wishedNumberOfStreamsOrNull;
        this.allowedNumberOfStreams = allowedNumberOfStreams;
        this.chunksByItemId = DownloadServerDownload.initChunksByItemId(itemIds, config.getChunkProvider());
        this.chunksBySequenceNumber = DownloadServerDownload.initChunksBySequenceNumber(this.chunksByItemId);
        this.ranges = DownloadServerDownload.initRanges(this.chunksByItemId);
        this.queue = new ChunkQueue();
        int i = 0;
        while (i < allowedNumberOfStreams) {
            this.streams.put(new DownloadStreamId(), null);
            ++i;
        }
    }

    private static Map<IDownloadItemId, List<Chunk>> initChunksByItemId(List<IDownloadItemId> itemIds, IChunkProvider chunksProvider) throws DownloadException {
        Map<IDownloadItemId, List<Chunk>> chunksByItemId = chunksProvider.getChunks(itemIds);
        if (chunksByItemId == null || chunksByItemId.isEmpty()) {
            throw new IllegalArgumentException("Chunks for item ids: " + itemIds + " were null or empty.");
        }
        for (IDownloadItemId itemId : itemIds) {
            List<Chunk> itemChunks = chunksByItemId.get(itemId);
            if (itemChunks != null && !itemChunks.isEmpty()) continue;
            throw new IllegalArgumentException("Chunks for item id: " + itemId + " were null or empty.");
        }
        return chunksByItemId;
    }

    private static Map<Integer, Chunk> initChunksBySequenceNumber(Map<IDownloadItemId, List<Chunk>> chunksByItemId) {
        HashMap<Integer, Chunk> chunksBySequenceNumber = new HashMap<Integer, Chunk>();
        for (List<Chunk> itemChunks : chunksByItemId.values()) {
            for (Chunk itemChunk : itemChunks) {
                chunksBySequenceNumber.put(itemChunk.getSequenceNumber(), itemChunk);
            }
        }
        return chunksBySequenceNumber;
    }

    private static Map<IDownloadItemId, DownloadRange> initRanges(Map<IDownloadItemId, List<Chunk>> chunksByItemId) {
        HashMap<IDownloadItemId, DownloadRange> ranges = new HashMap<IDownloadItemId, DownloadRange>();
        for (Map.Entry<IDownloadItemId, List<Chunk>> entry : chunksByItemId.entrySet()) {
            IDownloadItemId itemId = entry.getKey();
            List<Chunk> itemChunks = entry.getValue();
            int start = itemChunks.get(0).getSequenceNumber();
            int end = itemChunks.get(itemChunks.size() - 1).getSequenceNumber();
            ranges.put(itemId, new DownloadRange(start, end));
        }
        return ranges;
    }

    public IUserSessionId getUserSessionId() {
        return this.userSessionId;
    }

    public DownloadSessionId getDownloadSessionId() {
        return this.downloadSessionId;
    }

    public List<IDownloadItemId> getItemIds() {
        return Collections.unmodifiableList(this.itemIds);
    }

    public Map<IDownloadItemId, DownloadRange> getRanges() {
        return Collections.unmodifiableMap(this.ranges);
    }

    public List<Chunk> getChunks(IDownloadItemId itemId) {
        List<Chunk> list = this.chunksByItemId.get(itemId);
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadStreamId> getStreamIds() {
        Map<DownloadStreamId, DownloadInputStream> map = this.streams;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList<DownloadStreamId>(this.streams.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadState getState() {
        int currentNumberOfStreams = 0;
        Map<DownloadStreamId, DownloadInputStream> map = this.streams;
        synchronized (map) {
            for (DownloadInputStream stream : this.streams.values()) {
                if (stream == null) continue;
                ++currentNumberOfStreams;
            }
        }
        return new DownloadState(this.userSessionId, this.downloadSessionId, this.itemIds, this.wishedNumberOfStreams, this.allowedNumberOfStreams, currentNumberOfStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream download(DownloadStreamId streamId, Integer numberOfChunksOrNull) throws InvalidDownloadStreamException, DownloadException {
        Map<DownloadStreamId, DownloadInputStream> map = this.streams;
        synchronized (map) {
            DownloadInputStream stream;
            block8: {
                if (!this.streams.containsKey(streamId)) {
                    throw new InvalidDownloadStreamException(streamId);
                }
                stream = this.streams.get(streamId);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!this.config.getLogger().isEnabled(LogLevel.WARN)) break block8;
                        this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't close a download stream", e);
                    }
                }
            }
            stream = new DownloadInputStream(this.config.getLogger(), this.queue, this.config.getSerializerProvider().createChunkSerializer(), numberOfChunksOrNull);
            this.streams.put(streamId, stream);
            if (this.config.getLogger().isEnabled(LogLevel.DEBUG)) {
                this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "Returning input stream with queue: " + this.queue);
            }
            return stream;
        }
    }

    public void queue(List<DownloadRange> ranges) {
        this.queue.offer(ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Map<DownloadStreamId, DownloadInputStream> map = this.streams;
        synchronized (map) {
            for (InputStream inputStream : this.streams.values()) {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!this.config.getLogger().isEnabled(LogLevel.WARN)) continue;
                    this.config.getLogger().log(this.getClass(), LogLevel.WARN, "Couldn't close a download stream", e);
                }
            }
        }
    }

    private class ChunkQueue
    implements IChunkQueue {
        private Queue<Integer> queueList = new LinkedList<Integer>();
        private Set<Integer> queueSet = new HashSet<Integer>();

        private ChunkQueue() {
        }

        @Override
        public synchronized Chunk poll() {
            Integer sequenceNumber = this.queueList.poll();
            if (sequenceNumber != null) {
                this.queueSet.remove(sequenceNumber);
                return (Chunk)DownloadServerDownload.this.chunksBySequenceNumber.get(sequenceNumber);
            }
            return null;
        }

        public synchronized void offer(List<DownloadRange> ranges) {
            for (DownloadRange range : ranges) {
                int sequenceNumber = range.getStart();
                while (sequenceNumber <= range.getEnd()) {
                    if (DownloadServerDownload.this.chunksBySequenceNumber.containsKey(sequenceNumber)) {
                        if (!this.queueSet.contains(sequenceNumber)) {
                            this.queueSet.add(sequenceNumber);
                            this.queueList.add(sequenceNumber);
                        }
                    } else {
                        throw new IllegalArgumentException("Unknown chunk with sequence number: " + sequenceNumber);
                    }
                    ++sequenceNumber;
                }
            }
        }

        public synchronized String toString() {
            return this.queueList.toString();
        }
    }
}

