/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.EmptyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchIgnore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptionsToStringBuilder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchProperty;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptionsAllWebAppSettingsHandler;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptionsWebAppSettingsHandler;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonSortOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.fetchoptions.RoleAssignmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsFetchOptions;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonObject(value="as.dto.person.fetchoptions.PersonFetchOptions")
public class PersonFetchOptions
extends FetchOptions<Person>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private SpaceFetchOptions space;
    @JsonProperty
    private PersonFetchOptions registrator;
    @JsonProperty
    private RoleAssignmentFetchOptions roleAssignments;
    @JsonProperty
    @FetchProperty(handler=PersonFetchOptionsWebAppSettingsHandler.class)
    private Map<String, WebAppSettingsFetchOptions> webAppSettings;
    @JsonProperty
    @FetchProperty(handler=PersonFetchOptionsAllWebAppSettingsHandler.class)
    private boolean allWebAppSettings;
    @JsonProperty
    private PersonSortOptions sort;

    public SpaceFetchOptions withSpace() {
        if (this.space == null) {
            this.space = new SpaceFetchOptions();
        }
        return this.space;
    }

    public SpaceFetchOptions withSpaceUsing(SpaceFetchOptions fetchOptions) {
        this.space = fetchOptions;
        return this.space;
    }

    public boolean hasSpace() {
        return this.space != null;
    }

    public PersonFetchOptions withRegistrator() {
        if (this.registrator == null) {
            this.registrator = new PersonFetchOptions();
        }
        return this.registrator;
    }

    public PersonFetchOptions withRegistratorUsing(PersonFetchOptions fetchOptions) {
        this.registrator = fetchOptions;
        return this.registrator;
    }

    public boolean hasRegistrator() {
        return this.registrator != null;
    }

    public RoleAssignmentFetchOptions withRoleAssignments() {
        if (this.roleAssignments == null) {
            this.roleAssignments = new RoleAssignmentFetchOptions();
        }
        return this.roleAssignments;
    }

    public RoleAssignmentFetchOptions withRoleAssignmentsUsing(RoleAssignmentFetchOptions fetchOptions) {
        this.roleAssignments = fetchOptions;
        return this.roleAssignments;
    }

    public boolean hasRoleAssignments() {
        return this.roleAssignments != null;
    }

    @FetchIgnore
    public WebAppSettingsFetchOptions withWebAppSettings(String webAppId) {
        WebAppSettingsFetchOptions webAppFo;
        if (this.webAppSettings == null) {
            this.webAppSettings = new HashMap<String, WebAppSettingsFetchOptions>();
        }
        if ((webAppFo = this.webAppSettings.get(webAppId)) == null) {
            webAppFo = new WebAppSettingsFetchOptions();
            this.webAppSettings.put(webAppId, webAppFo);
        }
        return webAppFo;
    }

    @FetchIgnore
    public boolean hasWebAppSettings(String webAppId) {
        return this.webAppSettings != null && this.webAppSettings.get(webAppId) != null;
    }

    @FetchIgnore
    public Map<String, WebAppSettingsFetchOptions> withWebAppSettingsUsing(Map<String, WebAppSettingsFetchOptions> webAppSettings) {
        this.webAppSettings = webAppSettings;
        return this.webAppSettings;
    }

    @FetchIgnore
    public Map<String, WebAppSettingsFetchOptions> getWebAppSettings() {
        return this.webAppSettings;
    }

    @FetchIgnore
    public void withAllWebAppSettings() {
        this.allWebAppSettings = true;
    }

    @FetchIgnore
    public boolean hasAllWebAppSettings() {
        return this.allWebAppSettings;
    }

    @FetchIgnore
    public boolean withAllWebAppSettingsUsing(boolean allWebAppSettings) {
        this.allWebAppSettings = allWebAppSettings;
        return this.allWebAppSettings;
    }

    @JsonIgnore
    public PersonSortOptions sortBy() {
        if (this.sort == null) {
            this.sort = new PersonSortOptions();
        }
        return this.sort;
    }

    @JsonIgnore
    public PersonSortOptions getSortBy() {
        return this.sort;
    }

    @Override
    protected FetchOptionsToStringBuilder getFetchOptionsStringBuilder() {
        FetchOptionsToStringBuilder f = new FetchOptionsToStringBuilder("Person", this);
        f.addFetchOption("Space", this.space);
        f.addFetchOption("Registrator", this.registrator);
        f.addFetchOption("RoleAssignments", this.roleAssignments);
        if (this.webAppSettings != null && !this.webAppSettings.isEmpty()) {
            for (Map.Entry<String, WebAppSettingsFetchOptions> entry : this.webAppSettings.entrySet()) {
                f.addFetchOption("WebAppSettings [" + entry.getKey() + "]", entry.getValue());
            }
        }
        if (this.allWebAppSettings) {
            f.addFetchOption("AllWebAppSettings", new EmptyFetchOptions());
        }
        return f;
    }
}

