/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload;

import ch.ethz.sis.filetransfer.DownloadClientDownload;
import ch.ethz.sis.filetransfer.DownloadStatus;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.DataSetFilePermId;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.id.IDataSetFileId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FastDownloadResult {
    private static final Comparator<Map.Entry<IDownloadItemId, Path>> RESULT_ENTRY_COMPARATOR = new Comparator<Map.Entry<IDownloadItemId, Path>>(){

        @Override
        public int compare(Map.Entry<IDownloadItemId, Path> e1, Map.Entry<IDownloadItemId, Path> e2) {
            return e1.getKey().getId().compareTo(e2.getKey().getId());
        }
    };
    private DownloadStatus status;
    private Map<IDataSetFileId, Path> pathsById = new LinkedHashMap<IDataSetFileId, Path>();
    private String fileTransferUserSessionId;
    private String downloadSessionId;

    FastDownloadResult(DownloadClientDownload download) {
        this.fileTransferUserSessionId = download.getUserSession().getId();
        this.status = download.getStatus();
        if (DownloadStatus.FINISHED.equals((Object)this.status)) {
            ArrayList<Map.Entry<IDownloadItemId, Path>> entries = new ArrayList<Map.Entry<IDownloadItemId, Path>>(download.getResults().entrySet());
            Collections.sort(entries, RESULT_ENTRY_COMPARATOR);
            for (Map.Entry entry : entries) {
                String[] splittedId = ((IDownloadItemId)entry.getKey()).getId().split("/", 2);
                DataSetFilePermId fileId = new DataSetFilePermId(new DataSetPermId(splittedId[0]), splittedId[1]);
                this.pathsById.put(fileId, (Path)entry.getValue());
            }
        }
        if (!DownloadStatus.NEW.equals((Object)this.status)) {
            this.downloadSessionId = download.getDownloadSessionId().getId();
        }
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public Map<IDataSetFileId, Path> getPathsById() {
        return this.pathsById;
    }

    public String getFileTransferUserSessionId() {
        return this.fileTransferUserSessionId;
    }

    public String getDownloadSessionId() {
        return this.downloadSessionId;
    }

    public String toString() {
        return new ObjectToString(this).append("status", (Object)this.status).append("fileTransferUserSessionId", this.fileTransferUserSessionId).append("number of files", this.pathsById.size()).append("downloadSessionId", this.downloadSessionId).toString();
    }
}

