/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CandidateComponentsIndex {
    private final MultiValueMap<String, String> index;

    CandidateComponentsIndex(List<Properties> content) {
        this.index = CandidateComponentsIndex.parseIndex(content);
    }

    public Set<String> getCandidateTypes(String basePackage, String stereotype) {
        List candidates = (List)this.index.get(stereotype);
        if (candidates != null) {
            return candidates.parallelStream().filter(t -> t.startsWith(basePackage)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static MultiValueMap<String, String> parseIndex(List<Properties> content) {
        LinkedMultiValueMap<String, String> index = new LinkedMultiValueMap<String, String>();
        for (Properties entry : content) {
            entry.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(type, values) -> {
                String[] stereotypes;
                for (String stereotype : stereotypes = ((String)values).split(",")) {
                    index.add(stereotype, (String)type);
                }
            }));
        }
        return index;
    }
}

