/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.http.server.reactive.WriteResultPublisher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractListenerWriteProcessor<T>
implements Processor<T, Void> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final WriteResultPublisher resultPublisher = new WriteResultPublisher();
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    @Nullable
    protected volatile T currentData;
    private volatile boolean subscriberCompleted;
    @Nullable
    private Subscription subscription;

    public final void onSubscribe(Subscription subscription) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onSubscribe: " + subscription);
        }
        this.state.get().onSubscribe(this, subscription);
    }

    public final void onNext(T data) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onNext: " + data);
        }
        this.state.get().onNext(this, data);
    }

    public final void onError(Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onError: " + t);
        }
        this.state.get().onError(this, t);
    }

    public final void onComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onComplete");
        }
        this.state.get().onComplete(this);
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        this.resultPublisher.subscribe(subscriber);
    }

    public final void onWritePossible() {
        this.state.get().onWritePossible(this);
    }

    public void cancel() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    protected void receiveData(T data) {
        if (this.currentData != null) {
            throw new IllegalStateException("Current data not processed yet: " + this.currentData);
        }
        this.currentData = data;
    }

    protected abstract void releaseData();

    protected abstract boolean isDataEmpty(T var1);

    protected abstract boolean isWritePossible();

    protected abstract boolean write(T var1) throws IOException;

    protected void suspendWriting() {
    }

    protected void writingComplete() {
    }

    protected void writingFailed(Throwable ex) {
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private void writeIfPossible() {
        if (this.isWritePossible()) {
            this.onWritePossible();
        }
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            public <T> void onSubscribe(AbstractListenerWriteProcessor<T> processor, Subscription subscription) {
                Assert.notNull((Object)subscription, "Subscription must not be null");
                if (((AbstractListenerWriteProcessor)processor).changeState(this, 1.REQUESTED)) {
                    ((AbstractListenerWriteProcessor)processor).subscription = subscription;
                    subscription.request(1L);
                } else {
                    super.onSubscribe(processor, subscription);
                }
            }
        }
        ,
        REQUESTED{

            @Override
            public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
                if (processor.isDataEmpty(data)) {
                    Assert.state(((AbstractListenerWriteProcessor)processor).subscription != null, "No subscription");
                    ((AbstractListenerWriteProcessor)processor).subscription.request(1L);
                } else {
                    processor.receiveData(data);
                    if (((AbstractListenerWriteProcessor)processor).changeState(this, 2.RECEIVED)) {
                        ((AbstractListenerWriteProcessor)processor).writeIfPossible();
                    }
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                if (((AbstractListenerWriteProcessor)processor).changeState(this, 2.COMPLETED)) {
                    processor.writingComplete();
                    ((AbstractListenerWriteProcessor)processor).resultPublisher.publishComplete();
                }
            }
        }
        ,
        RECEIVED{

            @Override
            public <T> void onWritePossible(AbstractListenerWriteProcessor<T> processor) {
                if (processor.changeState(this, 3.WRITING)) {
                    Object data = processor.currentData;
                    Assert.state(data != null, "No data");
                    try {
                        boolean writeCompleted = processor.write(data);
                        if (writeCompleted) {
                            processor.releaseData();
                            if (!processor.subscriberCompleted) {
                                processor.changeState(3.WRITING, 3.REQUESTED);
                                processor.suspendWriting();
                                Assert.state(processor.subscription != null, "No subscription");
                                processor.subscription.request(1L);
                            } else {
                                processor.changeState(3.WRITING, 3.COMPLETED);
                                processor.writingComplete();
                                processor.resultPublisher.publishComplete();
                            }
                        } else {
                            processor.changeState(3.WRITING, 3.RECEIVED);
                            processor.writeIfPossible();
                        }
                    }
                    catch (IOException ex) {
                        processor.writingFailed(ex);
                    }
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                ((AbstractListenerWriteProcessor)processor).subscriberCompleted = true;
            }
        }
        ,
        WRITING{

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                ((AbstractListenerWriteProcessor)processor).subscriberCompleted = true;
            }
        }
        ,
        COMPLETED{

            @Override
            public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
            }

            @Override
            public <T> void onError(AbstractListenerWriteProcessor<T> processor, Throwable ex) {
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
            }
        };


        public <T> void onSubscribe(AbstractListenerWriteProcessor<T> processor, Subscription subscription) {
            subscription.cancel();
        }

        public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
            throw new IllegalStateException(this.toString());
        }

        public <T> void onError(AbstractListenerWriteProcessor<T> processor, Throwable ex) {
            if (((AbstractListenerWriteProcessor)processor).changeState(this, State.COMPLETED)) {
                processor.writingComplete();
                ((AbstractListenerWriteProcessor)processor).resultPublisher.publishError(ex);
            }
        }

        public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
            throw new IllegalStateException(this.toString());
        }

        public <T> void onWritePossible(AbstractListenerWriteProcessor<T> processor) {
        }
    }
}

