/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc2.CommonJ2ResultSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class Array
implements java.sql.Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public Array(BaseConnection baseConnection, int n, Field field, BaseResultSet baseResultSet) throws SQLException {
        this.conn = baseConnection;
        this.field = field;
        this.rs = baseResultSet;
        this.idx = n;
        this.rawString = this.rs.getString(n);
    }

    public void free() {
    }

    public Object getArray() throws SQLException {
        return this.getArray(1L, 0, (Map)null);
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArray(l, n, (Map)null);
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray(1L, 0, map);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        Object[] objectArray;
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (l < 1L) {
            throw new FMSQLException("The array index is out of range.", "22000");
        }
        Object[] objectArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            objectArray = this.rawString.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == 92) {
                    ++i;
                } else {
                    if (!bl2 && objectArray[i] == 123) {
                        if (bl) {
                            throw Driver.notImplemented();
                        }
                        bl = true;
                        continue;
                    }
                    if (objectArray[i] == 34) {
                        bl2 = !bl2;
                        continue;
                    }
                    if (!bl2 && (objectArray[i] == 44 || objectArray[i] == 125) || i == objectArray.length - 1) {
                        if (objectArray[i] != 34 && objectArray[i] != 125 && objectArray[i] != 44) {
                            stringBuffer.append((char)objectArray[i]);
                        }
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                }
                stringBuffer.append((char)objectArray[i]);
            }
        }
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        if (n == 0) {
            n = objectArray.length;
        }
        if (--l + (long)n > (long)objectArray.length) {
            throw new FMSQLException("The array index is out of range.", "22000");
        }
        int n2 = 0;
        switch (this.getBaseType()) {
            case -7: {
                objectArray2 = new boolean[n];
                while (n > 0) {
                    objectArray2[n2++] = CommonJ2ResultSet.toBoolean(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = new int[n];
                while (n > 0) {
                    ((int[])objectArray2)[n2++] = CommonJ2ResultSet.toInt(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case -5: {
                objectArray2 = new long[n];
                while (n > 0) {
                    ((long[])objectArray2)[n2++] = CommonJ2ResultSet.toLong(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 2: {
                objectArray2 = new BigDecimal[n];
                while (n > 0) {
                    ((BigDecimal[])objectArray2)[n2++] = CommonJ2ResultSet.toBigDecimal(objectArray[(int)l++], 0);
                    --n;
                }
                break;
            }
            case 7: {
                objectArray2 = new float[n];
                while (n > 0) {
                    ((float[])objectArray2)[n2++] = CommonJ2ResultSet.toFloat(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 8: {
                objectArray2 = new double[n];
                while (n > 0) {
                    ((double[])objectArray2)[n2++] = CommonJ2ResultSet.toDouble(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = new String[n];
                while (n > 0) {
                    ((String[])objectArray2)[n2++] = objectArray[(int)l++];
                    --n;
                }
                break;
            }
            case 91: {
                objectArray2 = new Date[n];
                while (n > 0) {
                    ((Date[])objectArray2)[n2++] = CommonJ2ResultSet.toDate(objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 92: {
                objectArray2 = new Time[n];
                while (n > 0) {
                    ((Time[])objectArray2)[n2++] = CommonJ2ResultSet.toTime(objectArray[(int)l++], this.rs, this.getBaseTypeName());
                    --n;
                }
                break;
            }
            case 93: {
                objectArray2 = new Timestamp[n];
                while (n > 0) {
                    ((Timestamp[])objectArray2)[n2++] = CommonJ2ResultSet.toTimestamp(objectArray[(int)l++], this.rs, this.getBaseTypeName());
                    --n;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return objectArray2;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String string = this.field.getFMType();
        if (string.charAt(0) == '_') {
            string = string.substring(1);
        }
        return string;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, (Map)null);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, (Map)null);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet(1L, 0, map);
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        Object object;
        Object object2 = this.getArray(l, n, map);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[2];
        fieldArray[0] = new Field(this.conn, "INDEX", this.conn.getFMType("int"), 2L);
        switch (this.getBaseType()) {
            case -7: {
                object = (boolean[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("int"), 1L);
                for (int i = 0; i < ((boolean[])object).length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(object[i] != false ? "YES" : "NO");
                    vector.addElement(byArray);
                }
            }
            case 5: {
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("int"), 2L);
            }
            case 4: {
                int[] nArray = (int[])object2;
                if (fieldArray[1] == null) {
                    fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("int"), 4L);
                }
                for (int i = 0; i < nArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(Integer.toString(nArray[i]));
                    vector.addElement(byArray);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("int"), 8L);
                for (int i = 0; i < lArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(Long.toString(lArray[i]));
                    vector.addElement(byArray);
                }
                break;
            }
            case 2: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("numeric"), -1L);
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(bigDecimalArray[i].toString());
                    vector.addElement(byArray);
                }
                break;
            }
            case 7: {
                float[] fArray = (float[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("decimal"), 4L);
                for (int i = 0; i < fArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(Float.toString(fArray[i]));
                    vector.addElement(byArray);
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("decimal"), 8L);
                for (int i = 0; i < dArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(Double.toString(dArray[i]));
                    vector.addElement(byArray);
                }
                break;
            }
            case 1: {
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("varchar"), 1L);
            }
            case 12: {
                String[] stringArray = (String[])object2;
                if (fieldArray[1] == null) {
                    fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("varchar"), -1L);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(stringArray[i]);
                    vector.addElement(byArray);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("date"), 4L);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(dateArray[i].toString());
                    vector.addElement(byArray);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("time"), 8L);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(timeArray[i].toString());
                    vector.addElement(byArray);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])object2;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getFMType("timestamp"), 8L);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + i));
                    byArray[1] = this.conn.getEncoding().encode(timestampArray[i].toString());
                    vector.addElement(byArray);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        object = (BaseStatement)((Object)this.conn.createStatement());
        return (ResultSet)((Object)object.createResultSet(-1, fieldArray, vector, "OK", 1, 0L, false));
    }

    public String toString() {
        return this.rawString;
    }
}

