/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.MessageBlockBytes;
import javax.crypto.Cipher;

public class MessageBlock {
    public static final int MAX_MESSAGE_BLOCK_SIZE = 65535;
    public static final int MESSAGE_BLOCK_CHUNK_SIZE = 65535;
    private static final int MAX_ENCRYPTION_BLOCK_SIZE = 16;
    private static final int ERR_LISTENER_SUCCESS = 0;
    private static final int ERR_LISTENER_DISCONNECT = -1;
    private static final int ERR_LISTENER_UNEXPECTED_RESPONSE_TYPE = -2;
    private static final int ERR_LISTENER_UNEXPECTED_REQUEST_TYPE = -3;
    private static final int ERR_LISTENER_PROTOCOL_ERROR = -4;
    public static final short FILEMAKER_PROTOCOL_VERSION_11 = 9;
    public static final short FILEMAKER_PROTOCOL_VERSION_12 = 11;
    public static final short FILEMAKER_PROTOCOL_VERSION = 11;
    protected int blockLength;
    protected int sequenceNumber;
    protected short blockType;
    public byte[] blockBytes;
    public int byteIndex;
    protected long stringBytesRemaining;
    protected boolean endOfMessage;

    public MessageBlock(int n, short s) {
        this.blockLength = 2;
        this.stringBytesRemaining = 0L;
        this.sequenceNumber = n;
        this.blockType = s;
        this.byteIndex = this.blockLength;
        this.blockBytes = new byte[65535];
        this.addParameter16(this.sequenceNumber);
        this.addParameter8(this.blockType);
    }

    public MessageBlock(byte[] byArray) {
        this.blockBytes = byArray;
        this.byteIndex = 0;
        this.stringBytesRemaining = 0L;
        this.blockLength = this.getParameter16();
        this.sequenceNumber = this.getParameter16();
        this.blockType = this.getParameter8();
    }

    public long getStringBytesRemaining() {
        return this.stringBytesRemaining;
    }

    public int setItemCount(int n, int n2) {
        for (int i = 0; i < 2; ++i) {
            this.blockBytes[n + i] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
        return this.blockLength;
    }

    public short getParameter8() {
        short s = this.blockBytes[this.byteIndex];
        ++this.byteIndex;
        return s;
    }

    public int getParameter16() {
        int n = (this.blockBytes[this.byteIndex + 1] & 0xFF) << 8 | this.blockBytes[this.byteIndex + 0] & 0xFF;
        this.byteIndex += 2;
        return n;
    }

    public long getParameter32() {
        long l = (this.blockBytes[this.byteIndex + 3] & 0xFF) << 24 | (this.blockBytes[this.byteIndex + 2] & 0xFF) << 16 | (this.blockBytes[this.byteIndex + 1] & 0xFF) << 8 | this.blockBytes[this.byteIndex + 0] & 0xFF;
        this.byteIndex += 4;
        return l;
    }

    public long getParameter64() {
        long l = (this.blockBytes[this.byteIndex + 7] & 0xFF) << 56 | (this.blockBytes[this.byteIndex + 6] & 0xFF) << 48 | (this.blockBytes[this.byteIndex + 5] & 0xFF) << 40 | (this.blockBytes[this.byteIndex + 4] & 0xFF) << 32 | (this.blockBytes[this.byteIndex + 3] & 0xFF) << 24 | (this.blockBytes[this.byteIndex + 2] & 0xFF) << 16 | (this.blockBytes[this.byteIndex + 1] & 0xFF) << 8 | this.blockBytes[this.byteIndex + 0] & 0xFF;
        this.byteIndex += 8;
        return l;
    }

    public String getParameter() {
        try {
            long l = this.getParameter32();
            long l2 = (long)this.byteIndex + l + 16L <= 65535L ? l : (long)(65519 - this.byteIndex);
            String string = new String(this.blockBytes, this.byteIndex, (int)l2, "UTF-8");
            this.stringBytesRemaining = l - l2;
            this.byteIndex = (int)((long)this.byteIndex + l2);
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public long getParameter(byte[] byArray, long l) {
        long l2 = 0L;
        try {
            long l3 = this.getParameter32();
            long l4 = (long)this.byteIndex + l3 + 16L <= 65535L ? l3 : (long)(65519 - this.byteIndex);
            System.arraycopy(this.blockBytes, this.byteIndex, byArray, (int)l, (int)l4);
            l2 = l3 - l4;
            this.byteIndex = (int)((long)this.byteIndex + l4);
            return l2;
        }
        catch (Exception exception) {
            return l2;
        }
    }

    public long addParameter(byte[] byArray, long l, long l2) {
        long l3 = 0L;
        long l4 = l2 - l;
        if (!this.addParameter32(l4)) {
            return l4;
        }
        long l5 = (long)this.blockLength + l4 + 16L <= 65535L ? l4 : (long)(65519 - this.blockLength);
        System.arraycopy(byArray, (int)l, this.blockBytes, this.blockLength, (int)l5);
        l3 = l4 - l5;
        this.blockLength = (int)((long)this.blockLength + l5);
        return l3;
    }

    public boolean addParameterInteger(long l, int n) {
        if (this.blockLength + n > 65535) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            this.blockBytes[this.blockLength + i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        this.blockLength += n;
        return true;
    }

    public boolean addParameter8(short s) {
        return this.addParameterInteger(s, 1);
    }

    public boolean addParameter16(int n) {
        return this.addParameterInteger(n, 2);
    }

    public boolean addParameter32(long l) {
        return this.addParameterInteger(l, 4);
    }

    public boolean addParameter64(long l) {
        return this.addParameterInteger(l, 8);
    }

    public int computeBlockSize() {
        int n = this.blockLength;
        this.blockBytes[0] = (byte)n;
        this.blockBytes[1] = (byte)(n >>> 8);
        int n2 = this.blockType;
        if (this.endOfMessage) {
            n2 = this.blockType | 0x80;
        }
        this.blockBytes[4] = (byte)n2;
        return this.blockLength;
    }

    public short getBlockType() {
        return this.blockType;
    }

    public boolean send(FMStream fMStream, boolean bl) {
        int n;
        int n2 = 0;
        this.endOfMessage = bl;
        this.computeBlockSize();
        byte[] byArray = new byte[this.blockLength + 16];
        byte[] byArray2 = new byte[16];
        Cipher cipher = fMStream.getE();
        try {
            for (n2 = 2; n2 < this.blockLength; n2 += 16) {
                n = 16;
                if (n2 + 16 >= this.blockLength) {
                    n = this.blockLength - n2;
                }
                System.arraycopy(this.blockBytes, n2, byArray2, 0, n);
                for (int i = n; i < 16; ++i) {
                    byArray2[i] = 0;
                }
                if (fMStream.getEncryption()) {
                    byte[] byArray3 = cipher.doFinal(byArray2);
                    System.arraycopy(byArray3, 0, byArray, n2, 16);
                    continue;
                }
                System.arraycopy(byArray2, 0, byArray, n2, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        this.blockLength = n2;
        this.computeBlockSize();
        byArray[0] = this.blockBytes[0];
        byArray[1] = this.blockBytes[1];
        n = 0;
        for (int i = 0; i < this.blockLength; i += n) {
            try {
                fMStream.Send(byArray, i, this.blockLength - i);
                fMStream.flush();
            }
            catch (Exception exception) {
                return false;
            }
            n = this.blockLength - i;
            if (n > 0) continue;
            return false;
        }
        return true;
    }

    public static MessageBlockBytes getBlock(FMStream fMStream) {
        int n;
        int n2;
        int n3;
        short s = 0;
        int n4 = 0;
        try {
            n4 = fMStream.ReceiveInteger(2);
        }
        catch (Exception exception) {
            return null;
        }
        boolean bl = false;
        int n5 = 2;
        if (n5 <= 0) {
            s = -4;
        }
        int n6 = n4;
        int n7 = 0;
        byte[] byArray = new byte[n6 + 2];
        byte[] byArray2 = new byte[n6 + 2];
        int n8 = n6 - 2;
        for (int i = 0; i < n8; i += n5) {
            try {
                fMStream.Receive(byArray2, 2 + i, n8 - i);
            }
            catch (Exception exception) {
                return null;
            }
            n5 = n8 - i;
            if (n5 > 0) continue;
            s = -4;
            return null;
        }
        byte[] byArray3 = new byte[16];
        Cipher cipher = fMStream.getD();
        try {
            byArray[0] = byArray2[0];
            byArray[1] = byArray2[1];
            for (n3 = 2; n3 < n6; n3 += 16) {
                n2 = 16;
                if (n3 + 16 >= n6) {
                    n2 = n6 - n3;
                }
                System.arraycopy(byArray2, n3, byArray3, 0, n2);
                for (int i = n2; i < 16; ++i) {
                    byArray3[i] = 0;
                }
                if (fMStream.getEncryption()) {
                    byte[] byArray4 = cipher.doFinal(byArray3);
                    System.arraycopy(byArray4, 0, byArray, n3, n2);
                    continue;
                }
                System.arraycopy(byArray3, 0, byArray, n3, n2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        n7 = (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
        n2 = byArray[4];
        if (n2 < 0) {
            n = n2 + 128;
            n3 = 1;
        } else {
            n = n2;
            n3 = 0;
        }
        return new MessageBlockBytes(byArray, (short)n, n7, n3 != 0, s);
    }
}

