/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload;

import ch.ethz.sis.filetransfer.AbstractBulkInputStream;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadItemId;
import ch.ethz.sis.filetransfer.DownloadItemNotFoundException;
import ch.ethz.sis.filetransfer.DownloadPreferences;
import ch.ethz.sis.filetransfer.DownloadRange;
import ch.ethz.sis.filetransfer.DownloadSession;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.DownloadStreamId;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadServer;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.InvalidDownloadSessionException;
import ch.ethz.sis.filetransfer.InvalidDownloadStreamException;
import ch.ethz.sis.filetransfer.InvalidUserSessionException;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadMethod;
import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.fastdownload.FastDownloadParameter;
import ch.ethz.sis.openbis.generic.dssapi.v3.fastdownload.FastDownloadUtils;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.util.Callback;

class RemoteFastDownloadServer
implements IDownloadServer {
    private String url;
    private int requestTimeoutInSeconds;
    private ObjectMapper objectMapper;

    RemoteFastDownloadServer(String baseUrl) {
        this(baseUrl, 300);
    }

    RemoteFastDownloadServer(String baseUrl, int requestTimeoutInSeconds) {
        this.url = baseUrl;
        this.requestTimeoutInSeconds = requestTimeoutInSeconds;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public DownloadSession startDownloadSession(IUserSessionId userSessionId, List<IDownloadItemId> itemIds, DownloadPreferences preferences) throws DownloadItemNotFoundException, InvalidUserSessionException, DownloadException {
        Request request = this.createRequest(new ParameterBuilder().method(FastDownloadMethod.START_DOWNLOAD_SESSION_METHOD).session(userSessionId).downloadItemIds(itemIds).wishedNumberOfStreams(preferences.getWishedNumberOfStreams()).parameters);
        try {
            ContentResponse response = this.sendAndCheckResponse(request);
            String contentAsString = response.getContentAsString();
            JsonNode tree = this.objectMapper.readTree(contentAsString);
            DownloadSessionId downloadSessionId = this.createDownloadSessionId(this.getScalarValue(tree, "downloadSessionId"));
            Map<IDownloadItemId, DownloadRange> ranges = this.getRanges(tree);
            List<DownloadStreamId> streamIds = this.getStreamIds(tree);
            return new DownloadSession(downloadSessionId, ranges, streamIds);
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    @Override
    public void queue(DownloadSessionId downloadSessionId, List<DownloadRange> ranges) throws InvalidUserSessionException, InvalidDownloadSessionException, DownloadException {
        Request request = this.createRequest(new ParameterBuilder().method(FastDownloadMethod.QUEUE_METHOD).downloadSession(downloadSessionId).ranges(ranges).parameters);
        this.sendAndCheckResponse(request);
    }

    @Override
    public InputStream download(DownloadSessionId downloadSessionId, DownloadStreamId streamId, Integer numberOfChunksOrNull) throws InvalidUserSessionException, InvalidDownloadSessionException, InvalidDownloadStreamException, DownloadException {
        ParameterBuilder builder = new ParameterBuilder().method(FastDownloadMethod.DOWNLOAD_METHOD).downloadSession(downloadSessionId).numberOfChunks(numberOfChunksOrNull).downloadStream(streamId);
        Request request = this.createRequest(builder.parameters);
        final PipedInputStream pipedInputStream = new PipedInputStream(0x100000);
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            final WritableByteChannel channel = Channels.newChannel(pipedOutputStream);
            request.send(new Response.Listener.Adapter(){

                @Override
                public void onContent(Response response, ByteBuffer content, Callback callback) {
                    try {
                        channel.write(content);
                        callback.succeeded();
                    }
                    catch (IOException e) {
                        callback.failed(e);
                    }
                }

                @Override
                public void onSuccess(Response response) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(e);
                    }
                }

                @Override
                public void onFailure(Response response, Throwable failure) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
        return new AbstractBulkInputStream(){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int numberOfBytesRead = 0;
                int offset = off;
                int numberOfBytesToRead = len;
                while (numberOfBytesRead < len) {
                    int numberOBytes = pipedInputStream.read(b, offset, numberOfBytesToRead);
                    if (numberOBytes < 0) {
                        return -1;
                    }
                    numberOfBytesRead += numberOBytes;
                    offset += numberOBytes;
                    numberOfBytesToRead -= numberOBytes;
                }
                return numberOfBytesRead;
            }
        };
    }

    @Override
    public void finishDownloadSession(DownloadSessionId downloadSessionId) throws DownloadException {
        Request request = this.createRequest(new ParameterBuilder().method(FastDownloadMethod.FINISH_DOWNLOAD_SESSION_METHOD).downloadSession(downloadSessionId).parameters);
        this.sendAndCheckResponse(request);
    }

    private ContentResponse sendAndCheckResponse(Request request) {
        try {
            JsonNode tree;
            RuntimeException exception;
            ContentResponse response = request.send();
            String mediaType = response.getMediaType();
            if (mediaType != null && mediaType.equals("application/json") && (exception = FastDownloadUtils.createExceptionFromJson(tree = this.objectMapper.readTree(response.getContentAsString()))) != null) {
                throw exception;
            }
            return response;
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    private DownloadSessionId createDownloadSessionId(String id) {
        DownloadSessionId downloadSessionId = new DownloadSessionId();
        ClassUtils.setFieldValue(downloadSessionId, "id", id);
        return downloadSessionId;
    }

    private Map<IDownloadItemId, DownloadRange> getRanges(JsonNode node) {
        Map<String, JsonNode> map = this.getMap(node, "ranges");
        LinkedHashMap<IDownloadItemId, DownloadRange> ranges = new LinkedHashMap<IDownloadItemId, DownloadRange>();
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            DownloadItemId downloadItemId = new DownloadItemId(entry.getKey());
            String rangeString = entry.getValue().asText();
            try {
                String[] splitted = rangeString.split(":");
                int start = Integer.parseInt(splitted[0]);
                int end = splitted.length == 1 ? start : Integer.parseInt(splitted[1]);
                ranges.put(downloadItemId, new DownloadRange(start, end));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid range definition for download item '" + downloadItemId.getId() + "': " + rangeString);
            }
        }
        return ranges;
    }

    private List<DownloadStreamId> getStreamIds(JsonNode node) {
        ArrayList<DownloadStreamId> ids = new ArrayList<DownloadStreamId>();
        for (JsonNode idNode : this.getArray(node, "streamIds")) {
            String streamIdString = idNode.asText();
            DownloadStreamId streamId = new DownloadStreamId();
            ClassUtils.setFieldValue(streamId, "id", streamIdString);
            ids.add(streamId);
        }
        return ids;
    }

    private List<JsonNode> getArray(JsonNode node, String fieldName) {
        JsonNode fieldNode = this.getFieldNode(node, fieldName);
        if (!fieldNode.isArray()) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is " + (fieldNode.isObject() ? "an object" : "a value") + " node instead of an array node.");
        }
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        Iterator<JsonNode> iterator = fieldNode.elements();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private Map<String, JsonNode> getMap(JsonNode node, String fieldName) {
        JsonNode fieldNode = this.getFieldNode(node, fieldName);
        if (!fieldNode.isObject()) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is " + (fieldNode.isArray() ? "an array" : "a value") + " node instead of a object node.");
        }
        LinkedHashMap<String, JsonNode> result = new LinkedHashMap<String, JsonNode>();
        Iterator<Map.Entry<String, JsonNode>> iterator = fieldNode.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> field = iterator.next();
            result.put(field.getKey(), field.getValue());
        }
        return result;
    }

    private String getScalarValue(JsonNode node, String fieldName) {
        JsonNode fieldNode = this.getFieldNode(node, fieldName);
        if (!fieldNode.isValueNode()) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is an " + (fieldNode.isArray() ? "array" : "object") + " node instead of a value node.");
        }
        return fieldNode.asText();
    }

    private JsonNode getFieldNode(JsonNode node, String fieldName) {
        JsonNode fieldNode = node.get(fieldName);
        if (fieldNode == null) {
            throw new IllegalArgumentException("No field '" + fieldName + "'.");
        }
        return fieldNode;
    }

    private Request createRequest(Map<FastDownloadParameter, String> parameters) {
        HttpClient httpClient = JettyHttpClientFactory.getHttpClient();
        return httpClient.newRequest(this.createUri(parameters)).timeout(this.requestTimeoutInSeconds, TimeUnit.SECONDS);
    }

    private String createUri(Map<FastDownloadParameter, String> parameters) {
        StringBuilder builder = new StringBuilder(this.url);
        int delim = 63;
        for (Map.Entry<FastDownloadParameter, String> entry : parameters.entrySet()) {
            builder.append((char)delim).append(this.encode(entry.getKey().getParameterName()));
            builder.append('=').append(this.encode(entry.getValue()));
            delim = 38;
        }
        String uri = builder.toString();
        return uri;
    }

    private String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
    }

    private static final class ParameterBuilder {
        private Map<FastDownloadParameter, String> parameters = new TreeMap<FastDownloadParameter, String>();

        private ParameterBuilder() {
        }

        ParameterBuilder method(FastDownloadMethod method) {
            this.parameters.put(FastDownloadParameter.METHOD_PARAMETER, method.getMethodName());
            return this;
        }

        ParameterBuilder session(IUserSessionId sessionId) {
            this.parameters.put(FastDownloadParameter.USER_SESSION_ID_PARAMETER, sessionId.getId());
            return this;
        }

        ParameterBuilder downloadSession(DownloadSessionId sessionId) {
            this.parameters.put(FastDownloadParameter.DOWNLOAD_SESSION_ID_PARAMETER, sessionId.getId());
            return this;
        }

        ParameterBuilder downloadStream(DownloadStreamId streamId) {
            this.parameters.put(FastDownloadParameter.DOWNLOAD_STREAM_ID_PARAMETER, streamId.getId());
            return this;
        }

        ParameterBuilder wishedNumberOfStreams(Integer wishedNumberOfStreams) {
            if (wishedNumberOfStreams != null) {
                this.parameters.put(FastDownloadParameter.WISHED_NUMBER_OF_STREAMS_PARAMETER, wishedNumberOfStreams.toString());
            }
            return this;
        }

        ParameterBuilder numberOfChunks(Integer numberOfChunks) {
            if (numberOfChunks != null) {
                this.parameters.put(FastDownloadParameter.NUMBER_OF_CHUNKS_PARAMETER, numberOfChunks.toString());
            }
            return this;
        }

        ParameterBuilder downloadItemIds(List<IDownloadItemId> ids) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            for (IDownloadItemId itemId : ids) {
                builder.append(itemId.getId());
            }
            this.parameters.put(FastDownloadParameter.DOWNLOAD_ITEM_IDS_PARAMETER, builder.toString());
            return this;
        }

        ParameterBuilder ranges(List<DownloadRange> ranges) {
            CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
            for (DownloadRange range : ranges) {
                builder.append(range.getStart() + ":" + range.getEnd());
            }
            this.parameters.put(FastDownloadParameter.RANGES_PARAMETER, builder.toString());
            return this;
        }
    }
}

