/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMCloseCursorRequest;
import com.filemaker.jdbc.FMColumnCountResponse;
import com.filemaker.jdbc.FMColumnDescriptionResponse;
import com.filemaker.jdbc.FMColumnPrivilegesRequest;
import com.filemaker.jdbc.FMColumnValue;
import com.filemaker.jdbc.FMColumnsRequest;
import com.filemaker.jdbc.FMEndStatementRequest;
import com.filemaker.jdbc.FMErrorResponse;
import com.filemaker.jdbc.FMExecuteRequest;
import com.filemaker.jdbc.FMIndexRequest;
import com.filemaker.jdbc.FMNextRowsRequest;
import com.filemaker.jdbc.FMPrepareRequest;
import com.filemaker.jdbc.FMPrimaryKeyRequest;
import com.filemaker.jdbc.FMQueryRequest;
import com.filemaker.jdbc.FMRowResponse;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.FMSuccessResponse;
import com.filemaker.jdbc.FMTablesRequest;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageBlockBytes;
import com.filemaker.jdbc.ProtocolMessage;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Vector;

public class FM_API {
    public static final short ROW_BUFFER_SIZE = 5000;
    private String[] m_sqlFrags;
    private Object[] m_binds;
    private String[] m_bindTypes;
    private BaseStatement statement;
    private BaseResultSet rs;
    private BaseConnection connection;
    private FMStream fmStream;
    private short protocolVersion = 0;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private boolean binaryCursor = false;
    private String status = null;
    private int update_count = 0;
    private long insert_type = 0L;
    private int maxRows;
    private int columnCount = 0;
    private int commandID = -1;

    public static BaseResultSet getTables(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getTables(string, encoding);
    }

    public static BaseResultSet getPrimaryKeys(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getPrimaryKeys(string, encoding);
    }

    public static BaseResultSet getIndexInfo(String string, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getIndexInfo(string, encoding);
    }

    public static BaseResultSet getColumns(String string, String string2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getColumns(string, string2, encoding);
    }

    public static BaseResultSet getColumnPrivileges(String string, String string2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        Encoding encoding = fM_API.connection.getEncoding();
        return fM_API.getColumnPrivileges(string, string2, encoding);
    }

    public static BaseResultSet execDirect(String[] stringArray, Object[] objectArray, String[] stringArray2, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.m_bindTypes = stringArray2;
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        return fM_API.execDirect();
    }

    public static int prepare(String[] stringArray, Object[] objectArray, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.statement = baseStatement;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        return fM_API.prepare();
    }

    public static BaseResultSet prepareRS(String[] stringArray, Object[] objectArray, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.statement = baseStatement;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        return fM_API.prepareRS();
    }

    public static BaseResultSet execute(int n, Object[] objectArray, String[] stringArray, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_binds = objectArray;
        fM_API.m_bindTypes = stringArray;
        fM_API.statement = baseStatement;
        fM_API.maxRows = baseStatement != null ? baseStatement.getMaxRows() : 0;
        fM_API.connection = baseStatement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        return fM_API.execute(n);
    }

    public static void execute(int n, Object[] objectArray, String[] stringArray, BaseResultSet baseResultSet) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_binds = objectArray;
        fM_API.m_bindTypes = stringArray;
        fM_API.rs = baseResultSet;
        fM_API.statement = fM_API.rs.getFMStatement();
        fM_API.maxRows = fM_API.statement != null ? fM_API.statement.getMaxRows() : 0;
        fM_API.columnCount = baseResultSet != null && baseResultSet.reallyResultSet() ? baseResultSet.getColumnCount() : 0;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        fM_API.execute(n);
    }

    public static void execDirect(String[] stringArray, Object[] objectArray, BaseResultSet baseResultSet) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.m_sqlFrags = stringArray;
        fM_API.m_binds = objectArray;
        fM_API.rs = baseResultSet;
        fM_API.statement = fM_API.rs.getFMStatement();
        fM_API.maxRows = fM_API.statement != null ? fM_API.statement.getMaxRows() : 0;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        fM_API.execDirect();
    }

    public static void endStatement(int n, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        fM_API.endStmt(n);
    }

    public static void closeCursor(int n, boolean bl, BaseStatement baseStatement) throws SQLException {
        FM_API fM_API = new FM_API();
        fM_API.statement = baseStatement;
        fM_API.connection = fM_API.statement.getFMConnection();
        fM_API.fmStream = fM_API.connection.getFMStream();
        fM_API.protocolVersion = fM_API.connection.getProtocolVersion();
        fM_API.closeServerCursor(n, bl);
    }

    private FM_API() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet execDirect() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        int n = 0;
        Encoding encoding = this.connection.getEncoding();
        String string = "";
        if (this.m_binds.length <= this.m_sqlFrags.length) {
            for (n = 0; n < this.m_binds.length; ++n) {
                string = string + this.m_sqlFrags[n];
                string = string + "?";
            }
        }
        while (n < this.m_sqlFrags.length) {
            string = string + this.m_sqlFrags[n];
            ++n;
        }
        FMQueryRequest fMQueryRequest = new FMQueryRequest(string, 0L, this.m_binds.length);
        for (n = 0; n < this.m_binds.length; ++n) {
            int n2 = this.connection.getFMTypeFromName(this.m_bindTypes[n]);
            short s = 0;
            if (n2 != 8) {
                short s2 = s = this.m_binds[n].toString().equalsIgnoreCase("null") ? (short)1 : 0;
            }
            if (n2 == 6) {
                fMQueryRequest.setParameterValue(n, (short)n2, s, (long)((byte[])this.m_binds[n]).length, (byte[])this.m_binds[n]);
                continue;
            }
            if (n2 == 8) {
                fMQueryRequest.setParameterValue(n, (short)6, (InputStream)this.m_binds[n]);
                continue;
            }
            fMQueryRequest.setParameterValue(n, (short)n2, s, (long)this.m_binds[n].toString().length(), this.m_binds[n].toString());
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMQueryRequest.send(this.fmStream);
            fMQueryRequest = null;
            this.getColumnDefinitions();
            this.rs = this.getAllResults();
        }
        return this.rs;
    }

    private BaseResultSet prepareRS() throws SQLException {
        this.prepare();
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int prepare() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        int n = 0;
        Encoding encoding = this.connection.getEncoding();
        this.commandID = -1;
        String string = "";
        if (this.m_binds.length <= this.m_sqlFrags.length) {
            for (n = 0; n < this.m_binds.length; ++n) {
                string = string + this.m_sqlFrags[n];
                string = string + "?";
            }
        }
        while (n < this.m_sqlFrags.length) {
            string = string + this.m_sqlFrags[n];
            ++n;
        }
        FMPrepareRequest fMPrepareRequest = new FMPrepareRequest(string);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMPrepareRequest.send(this.fmStream);
            try {
                if (this.protocolVersion == 9) {
                    boolean bl = false;
                    this.commandID = -1;
                    boolean bl2 = false;
                    MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                    byte[] byArray = messageBlockBytes.blockBytes;
                    short s = messageBlockBytes.commandType;
                    if (s != 83) {
                        if (s != 69) throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n2 = fMErrorResponse.getErrorCode();
                        String string2 = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string2, "HY000");
                    }
                    FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
                    this.commandID = fMSuccessResponse.getCommandID();
                    this.update_count = (int)fMSuccessResponse.getAffectedRowCount();
                    this.statement.setCommandID(this.commandID);
                } else {
                    this.getColumnDefinitions();
                }
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
            return this.commandID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet execute(int n) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        this.commandID = n;
        int n2 = 0;
        Encoding encoding = this.connection.getEncoding();
        FMExecuteRequest fMExecuteRequest = new FMExecuteRequest(this.commandID, 0L, this.m_binds.length);
        for (n2 = 0; n2 < this.m_binds.length; ++n2) {
            int n3 = this.connection.getFMTypeFromName(this.m_bindTypes[n2]);
            short s = 0;
            if (n3 != 8) {
                short s2 = s = this.m_binds[n2].toString().equalsIgnoreCase("null") ? (short)1 : 0;
            }
            if (n3 == 6) {
                fMExecuteRequest.setParameterValue(n2, (short)n3, s, (long)((byte[])this.m_binds[n2]).length, (byte[])this.m_binds[n2]);
                continue;
            }
            if (n3 == 8) {
                fMExecuteRequest.setParameterValue(n2, (short)6, (InputStream)this.m_binds[n2]);
                continue;
            }
            fMExecuteRequest.setParameterValue(n2, (short)n3, s, (long)this.m_binds[n2].toString().length(), this.m_binds[n2].toString());
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMExecuteRequest.send(this.fmStream);
            if (this.protocolVersion == 9) {
                this.getColumnDefinitions();
            } else {
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s = messageBlockBytes.commandType;
                if (s == 83) {
                    FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
                    this.update_count = (int)fMSuccessResponse.getAffectedRowCount();
                } else {
                    if (s == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n4 = fMErrorResponse.getErrorCode();
                        String string = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
                }
            }
            this.rs = this.getAllResults();
        }
        return this.rs;
    }

    private void getColumnDefinitions() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Fetch operation is not permitted.", "08003");
        }
        try {
            ProtocolMessage protocolMessage;
            this.columnCount = 0;
            this.commandID = -1;
            this.update_count = -1;
            boolean bl = false;
            MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
            byte[] byArray = messageBlockBytes.blockBytes;
            short s = messageBlockBytes.commandType;
            if (s == 85) {
                protocolMessage = new FMColumnCountResponse(byArray);
                this.commandID = ((FMColumnCountResponse)protocolMessage).getCommandID();
                this.columnCount = ((FMColumnCountResponse)protocolMessage).getColumnCount();
                this.statement.setCommandID(this.commandID);
                this.fields = new Field[this.columnCount];
            } else if (s == 83) {
                protocolMessage = new FMSuccessResponse(this.protocolVersion, byArray);
                this.commandID = ((FMSuccessResponse)protocolMessage).getCommandID();
                this.update_count = (int)((FMSuccessResponse)protocolMessage).getAffectedRowCount();
                if (this.protocolVersion >= 11) {
                    long l = ((FMSuccessResponse)protocolMessage).getLastRowID();
                    this.statement.setLastRowID(l);
                }
            } else {
                if (s == 69) {
                    FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                    int n = fMErrorResponse.getErrorCode();
                    String string = fMErrorResponse.getErrorMessage();
                    throw new FMSQLException(string, "HY000");
                }
                throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
            }
            for (int i = 0; i < this.columnCount; ++i) {
                messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byArray = messageBlockBytes.blockBytes;
                s = messageBlockBytes.commandType;
                if (s != 68) {
                    throw new FMSQLException("Unexpected listener response type (2) " + s, "08S01");
                }
                FMColumnDescriptionResponse fMColumnDescriptionResponse = new FMColumnDescriptionResponse(byArray);
                this.commandID = fMColumnDescriptionResponse.getCommandID();
                String string = fMColumnDescriptionResponse.getDatabaseName();
                String string2 = fMColumnDescriptionResponse.getTableName();
                String string3 = fMColumnDescriptionResponse.getColumnName();
                String string4 = fMColumnDescriptionResponse.getOriginalColumnName();
                short s2 = fMColumnDescriptionResponse.getColumnType();
                int n = fMColumnDescriptionResponse.getFlags();
                long l = fMColumnDescriptionResponse.getFieldSize();
                int n2 = fMColumnDescriptionResponse.getDecimalDigits();
                int n3 = this.connection.getSQLType(s2);
                String string5 = this.connection.getFMType(n3);
                this.fields[i] = new Field(this.connection, string3, n3, l, n);
            }
            if (this.rs == null) {
                this.rs = this.statement.createResultSet(this.commandID, this.fields, null, this.status, this.update_count, 0L, false);
            }
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "08007");
        }
    }

    private BaseResultSet getAllResults() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Fetch operation is not permitted.", "08003");
        }
        try {
            int n = 0;
            if (this.columnCount > 0) {
                boolean bl = false;
                boolean bl2 = false;
                FMNextRowsRequest fMNextRowsRequest = new FMNextRowsRequest(this.commandID, 0, 0L, 5000L);
                fMNextRowsRequest.send(this.fmStream);
                do {
                    FMColumnValue[] fMColumnValueArray;
                    ProtocolMessage protocolMessage;
                    MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                    byte[] byArray = messageBlockBytes.blockBytes;
                    short s = messageBlockBytes.commandType;
                    int n2 = messageBlockBytes.sequenceNumber;
                    boolean bl3 = messageBlockBytes.endOfMessage;
                    int n3 = 0;
                    if (s == 87) {
                        bl2 = false;
                        protocolMessage = new FMRowResponse(byArray);
                        while (true) {
                            if (n2 != 0) {
                                protocolMessage.append(n2, byArray);
                            }
                            if (bl3) break;
                            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                            byArray = messageBlockBytes.blockBytes;
                            s = messageBlockBytes.commandType;
                            n2 = messageBlockBytes.sequenceNumber;
                            bl3 = messageBlockBytes.endOfMessage;
                        }
                        this.commandID = ((FMRowResponse)protocolMessage).getCommandID();
                        n3 = ((FMRowResponse)protocolMessage).getColumnCount();
                        Vector vector = ((FMRowResponse)protocolMessage).getColumns();
                        fMColumnValueArray = new FMColumnValue[n3];
                        for (int i = 0; i < n3; ++i) {
                            FMColumnValue fMColumnValue = (FMColumnValue)vector.elementAt(i);
                            int n4 = fMColumnValue.columnNumber;
                            short s2 = fMColumnValue.isNull;
                            long l = fMColumnValue.totalFieldLength;
                            fMColumnValueArray[i] = s2 == 0 ? fMColumnValue : fMColumnValue;
                        }
                        if (this.maxRows <= 0 || n < this.maxRows) {
                            this.tuples.addElement(fMColumnValueArray);
                            ++n;
                        }
                    } else if (s == 83) {
                        if (bl2) {
                            bl = true;
                        }
                        bl2 = true;
                        protocolMessage = new FMSuccessResponse(this.protocolVersion, byArray);
                        this.update_count = (int)((FMSuccessResponse)protocolMessage).getAffectedRowCount();
                    } else {
                        if (s == 69) {
                            protocolMessage = new FMErrorResponse(byArray);
                            int n5 = ((FMErrorResponse)protocolMessage).getErrorCode();
                            fMColumnValueArray = ((FMErrorResponse)protocolMessage).getErrorMessage();
                            throw new FMSQLException((String)fMColumnValueArray, "HY000");
                        }
                        throw new FMSQLException("Unexpected listener response type (3) " + s, "08S01");
                    }
                    if (bl || !bl2) continue;
                    fMNextRowsRequest = new FMNextRowsRequest(this.commandID, 0, 0L, 5000L);
                    fMNextRowsRequest.send(this.fmStream);
                } while (!bl);
                this.rs.reInit(this.tuples, this.status, -1, this.insert_type, this.binaryCursor);
                return this.rs;
            }
            this.rs.reInit(this.tuples, this.status, this.update_count, this.insert_type, this.binaryCursor);
            return this.rs;
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "08007");
        }
    }

    private BaseResultSet next() throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Fetch operation is not permitted.", "08003");
        }
        try {
            int n = 0;
            if (this.columnCount > 0) {
                boolean bl = false;
                boolean bl2 = false;
                FMNextRowsRequest fMNextRowsRequest = new FMNextRowsRequest(this.commandID, 0, 0L, 5000L);
                fMNextRowsRequest.send(this.fmStream);
                do {
                    FMColumnValue[] fMColumnValueArray;
                    ProtocolMessage protocolMessage;
                    MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                    byte[] byArray = messageBlockBytes.blockBytes;
                    short s = messageBlockBytes.commandType;
                    int n2 = messageBlockBytes.sequenceNumber;
                    boolean bl3 = messageBlockBytes.endOfMessage;
                    int n3 = 0;
                    if (s == 87) {
                        bl2 = false;
                        protocolMessage = new FMRowResponse(byArray);
                        while (true) {
                            if (n2 != 0) {
                                protocolMessage.append(n2, byArray);
                            }
                            if (bl3) break;
                            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                            byArray = messageBlockBytes.blockBytes;
                            s = messageBlockBytes.commandType;
                            n2 = messageBlockBytes.sequenceNumber;
                            bl3 = messageBlockBytes.endOfMessage;
                        }
                        this.commandID = ((FMRowResponse)protocolMessage).getCommandID();
                        n3 = ((FMRowResponse)protocolMessage).getColumnCount();
                        Vector vector = ((FMRowResponse)protocolMessage).getColumns();
                        fMColumnValueArray = new FMColumnValue[n3];
                        for (int i = 0; i < n3; ++i) {
                            FMColumnValue fMColumnValue = (FMColumnValue)vector.elementAt(i);
                            int n4 = fMColumnValue.columnNumber;
                            short s2 = fMColumnValue.isNull;
                            long l = fMColumnValue.totalFieldLength;
                            fMColumnValueArray[i] = s2 == 0 ? fMColumnValue : fMColumnValue;
                        }
                        if (this.maxRows <= 0 || n < this.maxRows) {
                            this.tuples.addElement(fMColumnValueArray);
                            ++n;
                        }
                    } else if (s == 83) {
                        if (bl2) {
                            bl = true;
                        }
                        bl2 = true;
                        protocolMessage = new FMSuccessResponse(this.protocolVersion, byArray);
                        this.update_count = (int)((FMSuccessResponse)protocolMessage).getAffectedRowCount();
                    } else {
                        if (s == 69) {
                            protocolMessage = new FMErrorResponse(byArray);
                            int n5 = ((FMErrorResponse)protocolMessage).getErrorCode();
                            fMColumnValueArray = ((FMErrorResponse)protocolMessage).getErrorMessage();
                            throw new FMSQLException((String)fMColumnValueArray, "HY000");
                        }
                        throw new FMSQLException("Unexpected listener response type (3) " + s, "08S01");
                    }
                    if (bl || !bl2) continue;
                    bl = true;
                } while (!bl);
                this.rs.reInit(this.tuples, this.status, -1, this.insert_type, this.binaryCursor);
                return this.rs;
            }
            this.rs.reInit(this.tuples, this.status, this.update_count, this.insert_type, this.binaryCursor);
            return this.rs;
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "08007");
        }
    }

    private BaseResultSet getTables(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getTables() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMTablesRequest fMTablesRequest = new FMTablesRequest(string);
                fMTablesRequest.send(this.fmStream);
                this.getColumnDefinitions();
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getPrimaryKeys(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getPrimaryKeys() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMPrimaryKeyRequest fMPrimaryKeyRequest = new FMPrimaryKeyRequest(string);
                fMPrimaryKeyRequest.send(this.fmStream);
                this.getColumnDefinitions();
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getIndexInfo(String string, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getIndexInfo() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMIndexRequest fMIndexRequest = new FMIndexRequest(string);
                fMIndexRequest.send(this.fmStream);
                this.getColumnDefinitions();
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getColumns(String string, String string2, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getColumns() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMColumnsRequest fMColumnsRequest = new FMColumnsRequest(string, string2);
                fMColumnsRequest.send(this.fmStream);
                this.getColumnDefinitions();
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    private BaseResultSet getColumnPrivileges(String string, String string2, Encoding encoding) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. getColumnPrivileges() is not permitted.", "08003");
        }
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            try {
                FMColumnPrivilegesRequest fMColumnPrivilegesRequest = new FMColumnPrivilegesRequest(string, string2);
                fMColumnPrivilegesRequest.send(this.fmStream);
                this.getColumnDefinitions();
                this.rs = this.getAllResults();
                return this.rs;
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endStmt(int n) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        FMEndStatementRequest fMEndStatementRequest = new FMEndStatementRequest(n);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMEndStatementRequest.send(this.fmStream);
            try {
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s = messageBlockBytes.commandType;
                if (s != 83) {
                    if (s == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n2 = fMErrorResponse.getErrorCode();
                        String string = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s, "08S01");
                }
                FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerCursor(int n, boolean bl) throws SQLException {
        if (this.fmStream == null) {
            throw new FMSQLException("Connection is closed. Execute operation is not permitted.", "08003");
        }
        short s = 0;
        if (bl) {
            s = 1;
        }
        FMCloseCursorRequest fMCloseCursorRequest = new FMCloseCursorRequest(n, s);
        FMStream fMStream = this.fmStream;
        synchronized (fMStream) {
            fMCloseCursorRequest.send(this.fmStream);
            try {
                MessageBlockBytes messageBlockBytes = MessageBlock.getBlock(this.fmStream);
                byte[] byArray = messageBlockBytes.blockBytes;
                short s2 = messageBlockBytes.commandType;
                if (s2 != 83) {
                    if (s2 == 69) {
                        FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                        int n2 = fMErrorResponse.getErrorCode();
                        String string = fMErrorResponse.getErrorMessage();
                        throw new FMSQLException(string, "HY000");
                    }
                    throw new FMSQLException("Unexpected listener response type (1) " + s2, "08S01");
                }
                FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
            }
            catch (Exception exception) {
                throw new FMSQLException(exception.getMessage(), "08007");
            }
        }
    }
}

